"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _helpers = require("../../../../../helpers");
var _links = require("../../../../../common/components/links");
var _timeline = require("../../../../../../common/types/timeline");
var _draggables = require("../../../../../common/components/draggables");
var _empty_value = require("../../../../../common/components/empty_value");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _active_timeline_context = require("../../../../containers/active_timeline_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostNameComponent = ({
  fieldName,
  fieldType,
  isAggregatable,
  Component,
  contextId,
  eventId,
  isDraggable,
  isButton,
  onClick,
  title,
  value
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const hostName = `${value}`;
  const isInTimelineContext = hostName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.enableHostDetailsFlyout) && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const openHostDetailsSidePanel = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (onClick) {
      onClick();
    }
    if (eventContext && isInTimelineContext) {
      const {
        timelineID,
        tabType
      } = eventContext;
      const updatedExpandedDetail = {
        panelView: 'hostDetail',
        params: {
          hostName
        }
      };
      const scopedActions = (0, _helpers.getScopedActions)(timelineID);
      if (scopedActions) {
        dispatch(scopedActions.toggleDetailPanel({
          ...updatedExpandedDetail,
          id: timelineID,
          tabType: tabType
        }));
      }
      if (timelineID === _timeline.TimelineId.active && tabType === _timeline.TimelineTabs.query) {
        _active_timeline_context.activeTimeline.toggleExpandedDetail({
          ...updatedExpandedDetail
        });
      }
    }
  }, [onClick, eventContext, isInTimelineContext, hostName, dispatch]);

  // The below is explicitly defined this way as the onClick takes precedence when it and the href are both defined
  // When this component is used outside of timeline/alerts table (i.e. in the flyout) we would still like it to link to the Host Details page
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
    Component: Component,
    hostName: hostName,
    isButton: isButton,
    onClick: isInTimelineContext ? openHostDetailsSidePanel : undefined,
    title: title
  }, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
    "data-test-subj": "draggable-truncatable-content"
  }, hostName)), [Component, hostName, isButton, isInTimelineContext, openHostDetailsSidePanel, title]);
  return (0, _fp.isString)(value) && hostName.length > 0 ? isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
    isDraggable: isDraggable,
    tooltipContent: fieldName,
    value: hostName
  }, content) : content : (0, _empty_value.getEmptyTagValue)();
};
const HostName = /*#__PURE__*/_react.default.memo(HostNameComponent);
exports.HostName = HostName;
HostName.displayName = 'HostName';