"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderUrl = exports.renderEventModule = exports.RenderRuleName = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../../common/components/draggables");
var _empty_value = require("../../../../../common/components/empty_value");
var _redirect_to_detection_engine = require("../../../../../common/components/link_to/redirect_to_detection_engine");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _validators = require("../../../../../common/utils/validators");
var _color = _interopRequireDefault(require("../../../../../common/utils/logo_endpoint/64_color.svg"));
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../../app/types");
var _link_to = require("../../../../../common/components/link_to");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../../common/constants");
var _links = require("../../../../../common/components/links");
var _helpers = require("../../../../../common/components/links/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventModuleFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
const RenderRuleName = ({
  children,
  Component,
  contextId,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  isButton,
  onClick,
  linkValue,
  truncate,
  title,
  value
}) => {
  const ruleName = `${value}`;
  const ruleId = linkValue;
  const {
    search
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.rules);
  const {
    navigateToApp,
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const goToRuleDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.rules,
      path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', search)
    });
  }, [navigateToApp, ruleId, search]);
  const href = (0, _react.useMemo)(() => getUrlForApp(_constants.APP_UI_ID, {
    deepLinkId: _types.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', search)
  }), [getUrlForApp, ruleId, search]);
  const id = `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}-${ruleId}`;
  const link = (0, _react.useMemo)(() => {
    const content = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
      dataTestSubj: `formatted-field-${fieldName}`
    }, value) : value;
    if (isButton) {
      return /*#__PURE__*/_react.default.createElement(_helpers.GenericLinkButton, {
        Component: Component,
        dataTestSubj: "data-grid-host-details",
        href: href,
        iconType: "expand",
        onClick: onClick !== null && onClick !== void 0 ? onClick : goToRuleDetails,
        title: title !== null && title !== void 0 ? title : ruleName
      }, children);
    } else if (Component) {
      return /*#__PURE__*/_react.default.createElement(Component, {
        "aria-label": title,
        "data-test-subj": `view-${fieldName}`,
        iconType: "link",
        onClick: goToRuleDetails,
        title: title
      }, title !== null && title !== void 0 ? title : value);
    } else {
      return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
        onClick: goToRuleDetails,
        href: href,
        "data-test-subj": "ruleName"
      }, content);
    }
  }, [Component, children, fieldName, goToRuleDetails, href, isButton, onClick, ruleName, title, truncate, value]);
  if ((0, _fp.isString)(value) && ruleName.length > 0 && ruleId != null) {
    return isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      field: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      id: id,
      isDraggable: isDraggable,
      tooltipContent: value,
      value: value
    }, link) : link;
  } else if (value != null) {
    return isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      field: fieldName,
      fieldType: fieldType,
      isAggregatable: isAggregatable,
      id: id,
      isDraggable: isDraggable,
      tooltipContent: value,
      value: `${value}`
    }, value) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
  }
  return (0, _empty_value.getEmptyTagValue)();
};
exports.RenderRuleName = RenderRuleName;
const canYouAddEndpointLogo = (moduleName, endpointUrl) => moduleName.trim().toLocaleLowerCase() === 'endgame' && endpointUrl != null && !(0, _fp.isEmpty)(endpointUrl) && !(0, _validators.isUrlInvalid)(endpointUrl) && endpointUrl.includes('/alerts/');
const renderEventModule = ({
  contextId,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  linkValue,
  truncate,
  value
}) => {
  const moduleName = `${value}`;
  const endpointRefUrl = linkValue;
  const content = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, value) : value;
  return (0, _fp.isString)(value) && moduleName.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: endpointRefUrl != null && !(0, _fp.isEmpty)(endpointRefUrl) ? 'flexStart' : 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(EventModuleFlexItem, null, isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}-${moduleName}`,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    isDraggable: isDraggable,
    tooltipContent: value,
    value: value
  }, content) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content)), endpointRefUrl != null && canYouAddEndpointLogo(moduleName, endpointRefUrl) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "event-module-link-to-elastic-endpoint-security",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, i18n.LINK_ELASTIC_ENDPOINT_SECURITY), /*#__PURE__*/_react.default.createElement("p", null, endpointRefUrl))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: endpointRefUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _color.default,
    size: "m"
  }))))) : (0, _empty_value.getEmptyTagValue)();
};
exports.renderEventModule = renderEventModule;
const GenericLinkComponent = ({
  children,
  Component,
  dataTestSubj,
  href,
  onClick,
  title,
  iconType = 'link'
}) => {
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": dataTestSubj,
    href: href,
    iconType: iconType,
    onClick: onClick,
    title: title
  }, title !== null && title !== void 0 ? title : children) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": dataTestSubj,
    target: "_blank",
    href: href
  }, title !== null && title !== void 0 ? title : children);
};
const GenericLink = /*#__PURE__*/_react.default.memo(GenericLinkComponent);
const renderUrl = ({
  contextId,
  Component,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  truncate,
  title,
  value
}) => {
  const urlName = `${value}`;
  const isUrlValid = !(0, _validators.isUrlInvalid)(urlName);
  const formattedValue = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, value) : value;
  const content = isUrlValid ? /*#__PURE__*/_react.default.createElement(GenericLink, {
    Component: Component,
    href: urlName,
    dataTestSubj: "ata-grid-url",
    title: title,
    iconType: "link"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, formattedValue);
  return (0, _fp.isString)(value) && urlName.length > 0 ? isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    field: fieldName,
    fieldType: fieldType,
    isAggregatable: isAggregatable,
    id: `event-details-value-default-draggable-${contextId}-${eventId}-${fieldName}-${value}-${urlName}`,
    isDraggable: isDraggable,
    tooltipContent: value,
    value: value
  }, content) : content : (0, _empty_value.getEmptyTagValue)();
};
exports.renderUrl = renderUrl;