"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MatchDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/cti/constants");
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MatchDetails = ({
  contextId,
  eventId,
  isDraggable,
  sourceField,
  sourceValue
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  "data-test-subj": "threat-match-details",
  direction: "row",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "threat-match-details-source-field",
  eventId: eventId,
  field: _constants.INDICATOR_MATCHED_FIELD,
  isDraggable: isDraggable,
  value: sourceField,
  isAggregatable: true,
  fieldType: 'keyword'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_helpers.HorizontalSpacer, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "matched",
  id: "xpack.securitySolution.alerts.rowRenderers.cti.threatMatch.matchedVerb"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "threat-match-details-source-value",
  eventId: eventId,
  field: sourceField,
  isDraggable: isDraggable,
  value: sourceValue,
  isAggregatable: true,
  fieldType: 'keyword'
})));
exports.MatchDetails = MatchDetails;