"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/cti/constants");
var _draggables = require("../../../../../../common/components/draggables");
var _formatted_field = require("../formatted_field");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorDetails = ({
  contextId,
  eventId,
  feedName,
  indicatorReference,
  indicatorType,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "threat-match-indicator-details",
  direction: "row",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true
}, indicatorType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "threat-match-indicator-details-indicator-type",
  eventId: eventId,
  field: _constants.INDICATOR_MATCHED_TYPE,
  isDraggable: isDraggable,
  value: indicatorType,
  isAggregatable: true,
  fieldType: 'keyword'
})), feedName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_helpers.HorizontalSpacer, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "provided by",
  id: "xpack.securitySolution.alerts.rowRenderers.cti.threatMatch.providerPreposition"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "threat-match-indicator-details-indicator-feedName",
  eventId: eventId,
  field: _constants.FEED_NAME,
  isDraggable: isDraggable,
  value: feedName,
  isAggregatable: true,
  fieldType: 'keyword'
}))), indicatorReference && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_helpers.HorizontalSpacer, null, ':')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
  contextId: contextId,
  "data-test-subj": "threat-match-indicator-details-indicator-reference",
  eventId: eventId,
  fieldName: _constants.INDICATOR_REFERENCE,
  isDraggable: isDraggable,
  value: indicatorReference,
  isAggregatable: true,
  fieldType: 'keyword'
}))));
exports.IndicatorDetails = IndicatorDetails;