"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionUserHostWorkingDir = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../helpers");
var _host_working_dir = require("../host_working_dir");
var _primary_secondary_user_info = require("./primary_secondary_user_info");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SessionUserHostWorkingDir = /*#__PURE__*/_react.default.memo(({
  eventId,
  contextId,
  hostName,
  userName,
  primary,
  secondary,
  workingDirectory,
  session,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, i18n.SESSION), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: "auditd.session",
  value: session,
  iconType: "number",
  isDraggable: isDraggable,
  isAggregatable: true,
  fieldType: "keyword"
})), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_primary_secondary_user_info.PrimarySecondaryUserInfo, {
  contextId: contextId,
  eventId: eventId,
  userName: userName,
  primary: primary,
  secondary: secondary,
  isDraggable: isDraggable
})), hostName != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, '@'), /*#__PURE__*/_react.default.createElement(_host_working_dir.HostWorkingDir, {
  contextId: contextId,
  eventId: eventId,
  workingDirectory: workingDirectory,
  hostName: hostName,
  isDraggable: isDraggable
})));
exports.SessionUserHostWorkingDir = SessionUserHostWorkingDir;
SessionUserHostWorkingDir.displayName = 'SessionUserHostWorkingDir';