"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nilOrUnSet = exports.PrimarySecondaryUserInfo = exports.PrimarySecondary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nilOrUnSet = value => value == null || value.toLowerCase() === 'unset';
exports.nilOrUnSet = nilOrUnSet;
const PrimarySecondary = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  primary,
  secondary,
  isDraggable
}) => {
  if (nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      isDraggable: isDraggable,
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (nilOrUnSet(primary) && !nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (primary === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      isDraggable: isDraggable,
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, i18n.AS), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      isDraggable: isDraggable,
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    })));
  }
});
exports.PrimarySecondary = PrimarySecondary;
PrimarySecondary.displayName = 'PrimarySecondary';
const PrimarySecondaryUserInfo = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  userName,
  primary,
  secondary,
  isDraggable
}) => {
  if (nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(userName) && !nilOrUnSet(primary) && !nilOrUnSet(secondary) && userName === primary && userName === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      isDraggable: isDraggable,
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else if (!nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      isDraggable: isDraggable,
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword"
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(PrimarySecondary, {
      contextId: contextId,
      eventId: eventId,
      isDraggable: isDraggable,
      primary: primary,
      secondary: secondary
    });
  }
});
exports.PrimarySecondaryUserInfo = PrimarySecondaryUserInfo;
PrimarySecondaryUserInfo.displayName = 'PrimarySecondaryUserInfo';