"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU_ARE_IN_A_TABLE_CELL = exports.EVENT_HAS_NOTES = exports.EVENT_HAS_AN_EVENT_RENDERER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const YOU_ARE_IN_A_TABLE_CELL = ({
  column,
  row
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.youAreInATableCellScreenReaderOnly', {
  values: {
    column,
    row
  },
  defaultMessage: 'You are in a table cell. row: {row}, column: {column}'
});
exports.YOU_ARE_IN_A_TABLE_CELL = YOU_ARE_IN_A_TABLE_CELL;
const EVENT_HAS_AN_EVENT_RENDERER = row => _i18n.i18n.translate('xpack.securitySolution.timeline.eventHasEventRendererScreenReaderOnly', {
  values: {
    row
  },
  defaultMessage: 'The event in row {row} has an event renderer. Press shift + down arrow to focus it.'
});
exports.EVENT_HAS_AN_EVENT_RENDERER = EVENT_HAS_AN_EVENT_RENDERER;
const EVENT_HAS_NOTES = ({
  notesCount,
  row
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.eventHasNotesScreenReaderOnly', {
  values: {
    notesCount,
    row
  },
  defaultMessage: 'The event in row {row} has {notesCount, plural, =1 {a note} other {{notesCount} notes}}. Press shift + right arrow to focus notes.'
});
exports.EVENT_HAS_NOTES = EVENT_HAS_NOTES;