"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFilter = exports.DEFAULT_PLACEHOLDER = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PLACEHOLDER = 'Filter';
exports.DEFAULT_PLACEHOLDER = DEFAULT_PLACEHOLDER;
const FieldText = (0, _styledComponents.default)(_eui.EuiFieldText)`
  min-width: ${props => props.minwidth};
`;
FieldText.displayName = 'FieldText';

/** Renders a text-based column filter */
const TextFilter = /*#__PURE__*/_react.default.memo(({
  columnId,
  minWidth,
  filter = '',
  onFilterChange = _fp.noop,
  placeholder = DEFAULT_PLACEHOLDER
}) => {
  const onChange = event => {
    onFilterChange({
      columnId,
      filter: event.target.value
    });
  };
  return /*#__PURE__*/_react.default.createElement(FieldText, {
    "data-test-subj": "textFilter",
    minwidth: `${minWidth}px`,
    placeholder: placeholder,
    value: filter,
    onChange: onChange
  });
});
exports.TextFilter = TextFilter;
TextFilter.displayName = 'TextFilter';