"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoSaveWarningMsg = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_selector = require("../../../../common/hooks/use_selector");
var _actions = require("../../../../common/store/inputs/actions");
var _timeline = require("../../../store/timeline");
var _toasters = require("../../../../common/components/toasters");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoSaveWarningMsgComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const dispatchToaster = (0, _toasters.useStateToaster)()[1];
  const {
    timelineId,
    newTimelineModel
  } = (0, _use_selector.useDeepEqualSelector)(_timeline.timelineSelectors.autoSaveMsgSelector);
  const handleClick = (0, _react.useCallback)(() => {
    if (timelineId != null && newTimelineModel != null) {
      dispatch(_timeline.timelineActions.updateTimeline({
        id: timelineId,
        timeline: newTimelineModel
      }));
      dispatch(_timeline.timelineActions.updateAutoSaveMsg({
        timelineId: null,
        newTimelineModel: null
      }));
      dispatch((0, _actions.setTimelineRangeDatePicker)({
        from: (0, _fp.getOr)(0, 'dateRange.start', newTimelineModel),
        to: (0, _fp.getOr)(0, 'dateRange.end', newTimelineModel)
      }));
    }
  }, [dispatch, newTimelineModel, timelineId]);
  const TextComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: handleClick
  }, i18n.REFRESH_TIMELINE)))), [handleClick]);
  if (timelineId != null && newTimelineModel != null) {
    const toast = {
      id: 'AutoSaveWarningMsg',
      title: i18n.TITLE,
      color: 'warning',
      iconType: 'warning',
      toastLifeTimeMs: 10000,
      text: TextComponent
    };
    dispatchToaster({
      type: 'addToaster',
      toast
    });
  }
  return null;
};
AutoSaveWarningMsgComponent.displayName = 'AutoSaveWarningMsgComponent';
const AutoSaveWarningMsg = /*#__PURE__*/_react.default.memo(AutoSaveWarningMsgComponent);
exports.AutoSaveWarningMsg = AutoSaveWarningMsg;