"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserDetailsContentComponent = exports.UserDetailsContent = exports.QUERY_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_strategy = require("../../../../../common/search_strategy");
var _links = require("../../../../common/components/links");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _risk_score = require("../../../../explore/containers/risk_score");
var _hooks = require("./hooks");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _get_criteria_from_users_type = require("../../../../common/components/ml/criteria/get_criteria_from_users_type");
var _model = require("../../../../explore/users/store/model");
var _formatted_date = require("../../../../common/components/formatted_date");
var _risk_score_field = require("./risk_score_field");
var _observed_user = require("./observed_user");
var _managed_user = require("./managed_user");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_ID = 'usersDetailsQuery';
exports.QUERY_ID = QUERY_ID;
/**
 * This is a visual component. It doesn't access any external Context or API.
 * It designed for unit testing the UI and previewing changes on storybook.
 */
const UserDetailsContentComponent = ({
  userName,
  observedUser,
  managedUser,
  riskScoreState,
  contextID,
  isDraggable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fontSize: xlFontSize
  } = (0, _eui.useEuiFontSize)('xl');
  const lastSeenDate = (0, _react.useMemo)(() => (0, _lodash.max)([observedUser.lastSeen, managedUser.lastSeen].map(el => el.date && new Date(el.date))), [managedUser.lastSeen, observedUser.lastSeen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    "data-test-subj": "user-details-content-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18n.USER), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, observedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-details-content-observed-badge",
    color: "hollow"
  }, i18n.OBSERVED_BADGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, managedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-details-content-managed-badge",
    color: "hollow"
  }, i18n.MANAGED_BADGE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), observedUser.lastSeen.isLoading || managedUser.lastSeen.isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
    userName: userName
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
            font-size: ${xlFontSize};
            font-weight: ${euiTheme.font.weight.bold};
            ${(0, _eui.euiTextBreakWord)()}
          `
  }, userName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": 'user-details-content-lastSeen'
  }, i18n.LAST_SEEN, ': ', lastSeenDate && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: lastSeenDate
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_risk_score_field.RiskScoreField, {
    riskScoreState: riskScoreState
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_observed_user.ObservedUser, {
    observedUser: observedUser,
    contextID: contextID,
    isDraggable: isDraggable
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_managed_user.ManagedUser, {
    managedUser: managedUser,
    contextID: contextID,
    isDraggable: isDraggable
  }));
};
exports.UserDetailsContentComponent = UserDetailsContentComponent;
const UserDetailsContent = ({
  userName,
  contextID,
  isDraggable = false
}) => {
  const {
    to,
    from,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const riskScoreState = (0, _risk_score.useRiskScore)({
    riskEntity: _search_strategy.RiskScoreEntity.user
  });
  const observedUser = (0, _hooks.useObservedUser)(userName);
  const managedUser = (0, _hooks.useManagedUser)(userName);
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, userName),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(UserDetailsContentComponent, {
    userName: userName,
    managedUser: managedUser,
    observedUser: {
      ...observedUser,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    },
    riskScoreState: riskScoreState,
    contextID: contextID,
    isDraggable: isDraggable
  }));
};
exports.UserDetailsContent = UserDetailsContent;