"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_strategy = require("../../../../../common/search_strategy");
var _empty_value = require("../../../../common/components/empty_value");
var _common = require("../../../../explore/components/risk_score/severity/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreField = ({
  riskScoreState
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fontSize: xsFontSize
  } = (0, _eui.useEuiFontSize)('xs');
  const {
    data: userRisk,
    isLicenseValid: isRiskLicenseValid
  } = riskScoreState;
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  if (!isRiskLicenseValid) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "user-details-risk-score"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
            font-weight: ${euiTheme.font.weight.bold};
            font-size: ${xsFontSize};
            margin-right: ${euiTheme.size.xs};
          `
  }, i18n.RISK_SCORE, ': ')), userRiskData ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, Math.round(userRiskData.user.risk.calculated_score_norm)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_common.RiskScore, {
    severity: _search_strategy.RiskSeverity.high,
    hideBackgroundColor: true
  }))) : (0, _empty_value.getEmptyTagValue)());
};
exports.RiskScoreField = RiskScoreField;