"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservedUserTableColumns = exports.getManagedUserTableColumns = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _uiTheme = require("@kbn/ui-theme");
var _reactRedux = require("react-redux");
var _field_renderers = require("../../field_renderers/field_renderers");
var i18n = _interopRequireWildcard(require("./translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_date = require("../../../../common/components/formatted_date");
var _anomaly_scores = require("../../../../common/components/ml/score/anomaly_scores");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _constants = require("../../../../common/store/inputs/constants");
var _actions = require("../../../../common/store/inputs/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldColumn = {
  name: i18n.FIELD_COLUMN_TITLE,
  field: 'label',
  render: label => /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
        font-weight: ${_uiTheme.euiLightVars.euiFontWeightMedium};
        color: ${_uiTheme.euiLightVars.euiTitleColor};
      `
  }, label)
};
const getManagedUserTableColumns = (contextID, isDraggable) => [fieldColumn, {
  name: i18n.VALUES_COLUMN_TITLE,
  field: 'value',
  render: (value, {
    field
  }) => {
    return field && value ? /*#__PURE__*/_react2.default.createElement(_field_renderers.DefaultFieldRenderer, {
      rowItems: [value],
      attrName: field,
      idPrefix: contextID ? `managedUser-${contextID}` : 'managedUser',
      isDraggable: isDraggable
    }) : (0, _empty_value.defaultToEmptyTag)(value);
  }
}];
exports.getManagedUserTableColumns = getManagedUserTableColumns;
function isAnomalies(field, values) {
  return field === 'anomalies';
}
const getObservedUserTableColumns = (contextID, isDraggable) => [fieldColumn, {
  name: i18n.VALUES_COLUMN_TITLE,
  field: 'values',
  render: (values, {
    field
  }) => {
    if (isAnomalies(field, values) && values) {
      return /*#__PURE__*/_react2.default.createElement(AnomaliesField, {
        anomalies: values
      });
    }
    if (field === '@timestamp') {
      return /*#__PURE__*/_react2.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: (0, _fp.head)(values)
      });
    }
    return /*#__PURE__*/_react2.default.createElement(_field_renderers.DefaultFieldRenderer, {
      rowItems: values,
      attrName: field,
      idPrefix: contextID ? `observedUser-${contextID}` : 'observedUser',
      isDraggable: isDraggable
    });
  }
}];
exports.getObservedUserTableColumns = getObservedUserTableColumns;
const AnomaliesField = ({
  anomalies
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const narrowDateRange = (0, _react2.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react2.default.createElement(_anomaly_scores.AnomalyScores, {
    anomalies: anomalies.anomalies,
    startDate: from,
    endDate: to,
    isLoading: anomalies.isLoading,
    narrowDateRange: narrowDateRange,
    jobNameById: anomalies.jobNameById
  });
};