"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAlertDetailsFlyoutLink = void 0;
var _react = require("react");
var _constants = require("../../../../../common/constants");
var _alert_detail_path = require("../../../../../common/utils/alert_detail_path");
var _hooks = require("../../../../common/lib/kibana/hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAlertDetailsFlyoutLink = ({
  _id,
  _index,
  timestamp
}) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const alertDetailPath = (0, _alert_detail_path.buildAlertDetailPath)({
    alertId: _id,
    index: _index,
    timestamp
  });
  const isPreviewAlert = _index.includes(_constants.DEFAULT_PREVIEW_INDEX);

  // getAppUrl accounts for the users selected space
  const alertDetailsLink = (0, _react.useMemo)(() => {
    if (isPreviewAlert) return null;
    const url = getAppUrl({
      path: alertDetailPath
    });
    // We use window.location.origin instead of http.basePath as the http.basePath has to be configured in config dev yml
    return `${window.location.origin}${url}`;
  }, [isPreviewAlert, getAppUrl, alertDetailPath]);
  return alertDetailsLink;
};
exports.useGetAlertDetailsFlyoutLink = useGetAlertDetailsFlyoutLink;