"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBasicDataFromDetailsData = exports.getAlertIndexAlias = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _helpers = require("../../../../detections/components/host_isolation/helpers");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBasicDataFromDetailsData = data => {
  const isAlert = (0, _fp.some)({
    category: 'kibana',
    field: 'kibana.alert.rule.uuid'
  }, data);
  const ruleName = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.rule.name'
  }, data), [data]);
  const ruleDescription = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'kibana',
    field: 'kibana.alert.rule.description'
  }, data), [data]);
  const alertId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: '_id',
    field: '_id'
  }, data), [data]);
  const agentId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, data), [data]);
  const hostName = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'host',
    field: 'host.name'
  }, data), [data]);
  const userName = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'user',
    field: 'user.name'
  }, data), [data]);
  const timestamp = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'base',
    field: '@timestamp'
  }, data), [data]);
  return (0, _react.useMemo)(() => ({
    alertId,
    agentId,
    isAlert,
    hostName,
    userName,
    ruleName,
    timestamp,
    data,
    ruleDescription
  }), [agentId, alertId, hostName, isAlert, ruleName, timestamp, userName, data, ruleDescription]);
};

/*
The referenced alert _index in the flyout uses the `.internal.` such as
`.internal.alerts-security.alerts-spaceId` in the alert page flyout and
.internal.preview.alerts-security.alerts-spaceId` in the rule creation preview flyout
but we always want to use their respective aliase indices rather than accessing their backing .internal. indices.
*/
exports.useBasicDataFromDetailsData = useBasicDataFromDetailsData;
const getAlertIndexAlias = (index, spaceId = 'default') => {
  if (index.startsWith(`.internal${_constants.DEFAULT_ALERTS_INDEX}`)) {
    return `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`;
  } else if (index.startsWith(`.internal${_constants.DEFAULT_PREVIEW_INDEX}`)) {
    return `${_constants.DEFAULT_PREVIEW_INDEX}-${spaceId}`;
  }
};
exports.getAlertIndexAlias = getAlertIndexAlias;