"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FlyoutBody", {
  enumerable: true,
  get: function () {
    return _body.FlyoutBody;
  }
});
Object.defineProperty(exports, "FlyoutFooter", {
  enumerable: true,
  get: function () {
    return _footer.FlyoutFooter;
  }
});
Object.defineProperty(exports, "FlyoutHeader", {
  enumerable: true,
  get: function () {
    return _header.FlyoutHeader;
  }
});
exports.useToGetInternalFlyout = void 0;
var _common = require("@kbn/timelines-plugin/common");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../../common/types");
var _use_host_isolation_tools = require("../use_host_isolation_tools");
var _header = require("./header");
var _body = require("./body");
var _footer = require("./footer");
var _details = require("../../../../containers/details");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _model = require("../../../../../common/store/sourcerer/model");
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToGetInternalFlyout = () => {
  var _alert$indexName, _alert$id;
  const {
    browserFields,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const [alert, setAlert] = (0, _react.useState)({
    id: undefined,
    indexName: undefined
  });
  const [loading, detailsData, rawEventData, ecsData, refetchFlyoutData] = (0, _details.useTimelineEventsDetails)({
    entityType: _common.EntityType.EVENTS,
    indexName: (_alert$indexName = alert.indexName) !== null && _alert$indexName !== void 0 ? _alert$indexName : '',
    eventId: (_alert$id = alert.id) !== null && _alert$id !== void 0 ? _alert$id : '',
    runtimeMappings,
    skip: !alert.id
  });
  const {
    alertId,
    isAlert,
    hostName,
    ruleName,
    timestamp
  } = (0, _helpers.useBasicDataFromDetailsData)(detailsData);
  const {
    isolateAction,
    isHostIsolationPanelOpen,
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess,
    showAlertDetails,
    showHostIsolationPanel
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const body = (0, _react.useCallback)(({
    isLoading,
    alert: localAlert
  }) => {
    setAlert(prevAlert => {
      if (prevAlert.id !== localAlert._id) {
        return {
          id: localAlert._id,
          indexName: localAlert._index
        };
      }
      return prevAlert;
    });
    return /*#__PURE__*/_react.default.createElement(_body.FlyoutBody, {
      alertId: alertId,
      browserFields: browserFields,
      detailsData: detailsData,
      detailsEcsData: ecsData,
      event: {
        eventId: localAlert._id,
        indexName: localAlert._index
      },
      hostName: hostName !== null && hostName !== void 0 ? hostName : '',
      handleIsolationActionSuccess: handleIsolationActionSuccess,
      handleOnEventClosed: _fp.noop,
      isAlert: isAlert,
      isDraggable: false,
      isolateAction: isolateAction,
      isIsolateActionSuccessBannerVisible: isIsolateActionSuccessBannerVisible,
      isHostIsolationPanelOpen: isHostIsolationPanelOpen,
      loading: isLoading || loading,
      rawEventData: rawEventData,
      showAlertDetails: showAlertDetails,
      scopeId: _types.TimelineId.casePage,
      isReadOnly: false
    });
  }, [alertId, browserFields, detailsData, ecsData, handleIsolationActionSuccess, hostName, isAlert, isHostIsolationPanelOpen, isIsolateActionSuccessBannerVisible, isolateAction, loading, rawEventData, showAlertDetails]);
  const header = (0, _react.useCallback)(({
    isLoading
  }) => {
    var _alert$indexName2;
    return /*#__PURE__*/_react.default.createElement(_header.FlyoutHeaderContent, {
      isHostIsolationPanelOpen: isHostIsolationPanelOpen,
      isAlert: isAlert,
      eventIndex: (_alert$indexName2 = alert.indexName) !== null && _alert$indexName2 !== void 0 ? _alert$indexName2 : '',
      eventId: alertId,
      isolateAction: isolateAction,
      loading: isLoading || loading,
      ruleName: ruleName,
      showAlertDetails: showAlertDetails,
      timestamp: timestamp
    });
  }, [alert.indexName, isAlert, alertId, isHostIsolationPanelOpen, isolateAction, loading, ruleName, showAlertDetails, timestamp]);
  const footer = (0, _react.useCallback)(({
    isLoading,
    alert: localAlert
  }) => {
    return /*#__PURE__*/_react.default.createElement(_footer.FlyoutFooter, {
      detailsData: detailsData,
      detailsEcsData: ecsData,
      expandedEvent: {
        eventId: localAlert._id,
        indexName: localAlert._index
      },
      refetchFlyoutData: refetchFlyoutData,
      handleOnEventClosed: _fp.noop,
      isHostIsolationPanelOpen: isHostIsolationPanelOpen,
      isReadOnly: false,
      loadingEventDetails: isLoading || loading,
      onAddIsolationStatusClick: showHostIsolationPanel,
      scopeId: _types.TimelineId.casePage
    });
  }, [detailsData, ecsData, isHostIsolationPanelOpen, loading, refetchFlyoutData, showHostIsolationPanel]);
  return (0, _react.useMemo)(() => ({
    body,
    header,
    footer
  }), [body, header, footer]);
};
exports.useToGetInternalFlyout = useToGetInternalFlyout;