"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToAlertDetailsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../detections/components/host_isolation/translations");
var _translations2 = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackToAlertDetailsLinkComponent = ({
  showAlertDetails,
  isolateAction
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    iconSide: "left",
    flush: "left",
    onClick: showAlertDetails
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations2.ALERT_DETAILS))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, isolateAction === 'isolateHost' ? _translations.ISOLATE_HOST : _translations.UNISOLATE_HOST)));
};
const BackToAlertDetailsLink = /*#__PURE__*/_react.default.memo(BackToAlertDetailsLinkComponent);
exports.BackToAlertDetailsLink = BackToAlertDetailsLink;