"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableEventTitle = exports.ExpandableEvent = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _link_to = require("../../../../common/components/link_to");
var _links = require("../../../../common/components/links");
var _event_details = require("../../../../common/components/event_details/event_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../../../common/components/event_details/translations");
var _formatted_date = require("../../../../common/components/formatted_date");
var _constants = require("../../../../../common/constants");
var _use_get_alert_details_flyout_link = require("./use_get_alert_details_flyout_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 0 1 auto;
  ${({
  theme
}) => `margin-top: ${theme.eui.euiSizeS};`}
`;
const StyledFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    flex: 1 0 0;
    overflow: hidden;
  }
`;
const ExpandableEventTitle = /*#__PURE__*/_react.default.memo(({
  eventId,
  eventIndex,
  isAlert,
  loading,
  handleOnEventClosed,
  promptContextId,
  ruleName,
  timestamp
}) => {
  const isAssistantEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('assistantEnabled');
  const isAlertDetailsPageEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertDetailsPageEnabled');
  const {
    onClick
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _constants.SecurityPageName.alerts,
    path: eventId && isAlert ? (0, _link_to.getAlertDetailsUrl)(eventId) : ''
  });
  const alertDetailsLink = (0, _use_get_alert_details_flyout_link.useGetAlertDetailsFlyoutLink)({
    _id: eventId,
    _index: eventIndex,
    timestamp
  });
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, isAlert && !(0, _fp.isEmpty)(ruleName) ? ruleName : i18n.EVENT_DETAILS)), timestamp && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  })), isAlert && eventId && isAlertDetailsPageEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    "data-test-subj": "open-alert-details-page",
    deepLinkId: _constants.SecurityPageName.alerts,
    onClick: onClick
  }, i18n.OPEN_ALERT_DETAILS_PAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd"
  }, handleOnEventClosed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": i18n.CLOSE,
    onClick: handleOnEventClosed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "none"
  }, isAssistantEnabled && promptContextId != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatById, {
    conversationId: isAlert ? _translations2.ALERT_SUMMARY_CONVERSATION_ID : _translations2.EVENT_SUMMARY_CONVERSATION_ID,
    promptContextId: promptContextId
  })), isAlert && alertDetailsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: alertDetailsLink
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: copy,
    iconType: "share",
    "data-test-subj": "copy-alert-flyout-link"
  }, i18n.SHARE_ALERT))))))));
});
exports.ExpandableEventTitle = ExpandableEventTitle;
ExpandableEventTitle.displayName = 'ExpandableEventTitle';
const ExpandableEvent = /*#__PURE__*/_react.default.memo(({
  browserFields,
  event,
  scopeId,
  timelineTabType,
  isAlert,
  isDraggable,
  loading,
  detailsData,
  detailsEcsData,
  rawEventData,
  handleOnEventClosed,
  isReadOnly
}) => {
  if (!event.eventId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, i18n.EVENT_DETAILS_PLACEHOLDER);
  }
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 10
    });
  }
  return /*#__PURE__*/_react.default.createElement(StyledFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_event_details.EventDetails, {
    browserFields: browserFields,
    data: detailsData !== null && detailsData !== void 0 ? detailsData : [],
    detailsEcsData: detailsEcsData,
    id: event.eventId,
    isAlert: isAlert,
    indexName: event.indexName,
    isDraggable: isDraggable,
    rawEventData: rawEventData,
    scopeId: scopeId,
    timelineTabType: timelineTabType,
    handleOnEventClosed: handleOnEventClosed,
    isReadOnly: isReadOnly
  })));
});
exports.ExpandableEvent = ExpandableEvent;
ExpandableEvent.displayName = 'ExpandableEvent';