"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulRowRenderersBrowser = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../common/types/timeline");
var _use_selector = require("../../../common/hooks/use_selector");
var _actions = require("../../store/timeline/actions");
var _timeline2 = require("../../store/timeline");
var _defaults = require("../../store/timeline/defaults");
var _row_renderers_browser = require("./row_renderers_browser");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiModal = (0, _styledComponents.default)(_eui.EuiModal)`
  ${({
  theme
}) => `margin-top: ${theme.eui.euiSizeXXL};`}
  max-width: 95vw;
  min-height: 90vh;

  > .euiModal__flex {
    max-height: 90vh;
  }
`;
const StyledEuiModalBody = (0, _styledComponents.default)(_eui.EuiModalBody)`
  .euiModalBody__overflow {
    display: flex;
    align-items: stretch;
    overflow: hidden;

    > div {
      display: flex;
      flex-direction: column;
      flex: 1;

      > div:first-child {
        flex: 0;
      }

      .euiBasicTable {
        flex: 1;
        overflow: auto;
      }
    }
  }
`;
const StatefulRowRenderersBrowserComponent = ({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const excludedRowRendererIds = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).excludedRowRendererIds;
  });
  const [show, setShow] = (0, _react.useState)(false);
  const setExcludedRowRendererIds = (0, _react.useCallback)(payload => dispatch((0, _actions.setExcludedRowRendererIds)({
    id: timelineId,
    excludedRowRendererIds: payload
  })), [dispatch, timelineId]);
  const toggleShow = (0, _react.useCallback)(() => setShow(!show), [show]);
  const hideFieldBrowser = (0, _react.useCallback)(() => setShow(false), []);
  const handleDisableAll = (0, _react.useCallback)(() => {
    setExcludedRowRendererIds(Object.values(_timeline.RowRendererId));
  }, [setExcludedRowRendererIds]);
  const handleEnableAll = (0, _react.useCallback)(() => {
    setExcludedRowRendererIds([]);
  }, [setExcludedRowRendererIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CUSTOMIZE_EVENT_RENDERERS_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CUSTOMIZE_EVENT_RENDERERS_TITLE,
    "data-test-subj": "show-row-renderers-gear",
    iconType: "gear",
    onClick: toggleShow
  }, i18n.EVENT_RENDERERS_TITLE)), show && /*#__PURE__*/_react.default.createElement(StyledEuiModal, {
    onClose: hideFieldBrowser,
    "data-test-subj": "row-renderers-modal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.CUSTOMIZE_EVENT_RENDERERS_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18n.CUSTOMIZE_EVENT_RENDERERS_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "data-test-subj": "disable-all",
    onClick: handleDisableAll
  }, i18n.DISABLE_ALL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    size: "s",
    "data-test-subj": "enable-all",
    onClick: handleEnableAll
  }, i18n.ENABLE_ALL)))))), /*#__PURE__*/_react.default.createElement(StyledEuiModalBody, null, /*#__PURE__*/_react.default.createElement(_row_renderers_browser.RowRenderersBrowser, {
    excludedRowRendererIds: excludedRowRendererIds,
    setExcludedRowRendererIds: setExcludedRowRendererIds
  }))));
};
const StatefulRowRenderersBrowser = /*#__PURE__*/_react.default.memo(StatefulRowRenderersBrowserComponent);
exports.StatefulRowRenderersBrowser = StatefulRowRenderersBrowser;