"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineTypes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _timeline = require("../../../../common/types/timeline");
var _types = require("../../../app/types");
var _link_to = require("../../../common/components/link_to");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("./types");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineTypes = ({
  defaultTimelineCount,
  templateTimelineCount
}) => {
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const {
    navigateToUrl
  } = (0, _kibana.useKibana)().services.application;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const [timelineType, setTimelineTypes] = (0, _react.useState)(tabName === _timeline.TimelineType.default || tabName === _timeline.TimelineType.template ? tabName : _timeline.TimelineType.default);
  const timelineUrl = formatUrl((0, _link_to.getTimelineTabsUrl)(_timeline.TimelineType.default, urlSearch));
  const templateUrl = formatUrl((0, _link_to.getTimelineTabsUrl)(_timeline.TimelineType.template, urlSearch));
  const goToTimeline = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(timelineUrl);
  }, [navigateToUrl, timelineUrl]);
  const goToTemplateTimeline = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(templateUrl);
  }, [navigateToUrl, templateUrl]);
  const getFilterOrTabs = (0, _react.useCallback)(timelineTabsStyle => [{
    id: _timeline.TimelineType.default,
    name: i18n.TAB_TIMELINES,
    href: timelineUrl,
    disabled: false,
    onClick: timelineTabsStyle === _types2.TimelineTabsStyle.tab ? goToTimeline : _fp.noop
  }, {
    id: _timeline.TimelineType.template,
    name: i18n.TAB_TEMPLATES,
    href: templateUrl,
    disabled: false,
    onClick: timelineTabsStyle === _types2.TimelineTabsStyle.tab ? goToTemplateTimeline : _fp.noop
  }], [timelineUrl, templateUrl, goToTimeline, goToTemplateTimeline]);
  const onFilterClicked = (0, _react.useCallback)((tabId, tabStyle) => {
    setTimelineTypes(prevTimelineTypes => {
      if (prevTimelineTypes !== tabId) {
        setTimelineTypes(tabId);
      }
      return prevTimelineTypes;
    });
  }, [setTimelineTypes]);
  const timelineTabs = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      "data-test-subj": "open-timeline-subtabs"
    }, getFilterOrTabs(_types2.TimelineTabsStyle.tab).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": `timeline-${_types2.TimelineTabsStyle.tab}-${tab.id}`,
      isSelected: tab.id === tabName,
      disabled: tab.disabled,
      key: `timeline-${_types2.TimelineTabsStyle.tab}-${tab.id}`,
      href: tab.href,
      onClick: ev => {
        tab.onClick(ev);
        onFilterClicked(tab.id, _types2.TimelineTabsStyle.tab);
      }
    }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tabName]);
  const timelineFilters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, getFilterOrTabs(_types2.TimelineTabsStyle.filter).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": `open-timeline-modal-body-${_types2.TimelineTabsStyle.filter}-${tab.id}`,
      isSelected: tab.id === timelineType,
      key: `timeline-${_types2.TimelineTabsStyle.filter}-${tab.id}`,
      onClick: ev => {
        tab.onClick(ev);
        onFilterClicked(tab.id, _types2.TimelineTabsStyle.filter);
      }
    }, tab.name)));
  }, [timelineType, getFilterOrTabs, onFilterClicked]);
  return {
    timelineType,
    timelineTabs,
    timelineFilters
  };
};
exports.useTimelineTypes = useTimelineTypes;