"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _timeline = require("../../../../common/types/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../containers/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineStatus = ({
  timelineType,
  elasticTemplateTimelineCount,
  customTemplateTimelineCount
}) => {
  const [selectedTab, setSelectedTab] = (0, _react.useState)(null);
  const isTemplateFilterEnabled = (0, _react.useMemo)(() => timelineType === _timeline.TimelineType.template, [timelineType]);
  const templateTimelineType = (0, _react.useMemo)(() => !isTemplateFilterEnabled ? null : selectedTab, [selectedTab, isTemplateFilterEnabled]);
  const timelineStatus = (0, _react.useMemo)(() => templateTimelineType == null ? null : templateTimelineType === _timeline.TemplateTimelineType.elastic ? _timeline.TimelineStatus.immutable : _timeline.TimelineStatus.active, [templateTimelineType]);
  const filters = (0, _react.useMemo)(() => [{
    id: _timeline.TemplateTimelineType.elastic,
    name: i18n.FILTER_ELASTIC_TIMELINES,
    disabled: !isTemplateFilterEnabled,
    withNext: true,
    count: elasticTemplateTimelineCount !== null && elasticTemplateTimelineCount !== void 0 ? elasticTemplateTimelineCount : undefined
  }, {
    id: _timeline.TemplateTimelineType.custom,
    name: i18n.FILTER_CUSTOM_TIMELINES,
    disabled: !isTemplateFilterEnabled,
    withNext: false,
    count: customTemplateTimelineCount !== null && customTemplateTimelineCount !== void 0 ? customTemplateTimelineCount : undefined
  }], [customTemplateTimelineCount, elasticTemplateTimelineCount, isTemplateFilterEnabled]);
  const onFilterClicked = (0, _react.useCallback)(tabId => {
    if (selectedTab === tabId) {
      setSelectedTab(null);
    } else {
      setSelectedTab(tabId);
    }
  }, [setSelectedTab, selectedTab]);
  const templateTimelineFilter = (0, _react.useMemo)(() => {
    return isTemplateFilterEnabled ? filters.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      hasActiveFilters: tab.id === templateTimelineType,
      key: `template-timeline-filter-${tab.id}`,
      numFilters: tab.count,
      onClick: onFilterClicked.bind(null, tab.id),
      withNext: tab.withNext,
      isDisabled: tab.disabled,
      "data-test-subj": tab.name
    }, tab.name)) : null;
  }, [templateTimelineType, filters, isTemplateFilterEnabled, onFilterClicked]);
  const installPrepackagedTimelines = (0, _react.useCallback)(async () => {
    if (templateTimelineType !== _timeline.TemplateTimelineType.custom) {
      await (0, _api.installPrepackedTimelines)();
    }
  }, [templateTimelineType]);
  return {
    timelineStatus,
    templateTimelineType,
    templateTimelineFilter,
    installPrepackagedTimelines
  };
};
exports.useTimelineStatus = useTimelineStatus;