"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelinesTableColumns = exports.TimelinesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("../translations"));
var _actions_columns = require("./actions_columns");
var _common_columns = require("./common_columns");
var _extended_columns = require("./extended_columns");
var _icon_header_columns = require("./icon_header_columns");
var _timeline = require("../../../../../common/types/timeline");
var _user_privileges = require("../../../../common/components/user_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// there are a number of type mismatches across this file
const EuiBasicTable = _eui.EuiBasicTable; // eslint-disable-line @typescript-eslint/no-explicit-any

const BasicTable = (0, _styledComponents.default)(EuiBasicTable)`
  .euiTableCellContent {
    animation: none; /* Prevents applying max-height from animation */
  }

  .euiTableRow-isExpandedRow .euiTableCellContent__text {
    width: 100%; /* Fixes collapsing nested flex content in IE11 */
  }
`;
BasicTable.displayName = 'BasicTable';

/**
 * Returns the column definitions (passed as the `columns` prop to
 * `EuiBasicTable`) that are displayed in the compact `Open Timeline` modal
 * view, and the full view shown in the `All Timelines` view of the
 * `Timelines` page
 */

const getTimelinesTableColumns = ({
  actionTimelineToShow,
  deleteTimelines,
  enableExportTimelineDownloader,
  itemIdToExpandedNotesRowMap,
  onCreateRule,
  onCreateRuleFromEql,
  onOpenDeleteTimelineModal,
  onOpenTimeline,
  onToggleShowNotes,
  showExtendedColumns,
  timelineType,
  hasCrudAccess
}) => {
  return [...(0, _common_columns.getCommonColumns)({
    itemIdToExpandedNotesRowMap,
    onOpenTimeline,
    onToggleShowNotes,
    timelineType
  }), ...(0, _extended_columns.getExtendedColumns)(showExtendedColumns), ...(0, _icon_header_columns.getIconHeaderColumns)({
    timelineType
  }), ...(actionTimelineToShow.length ? (0, _actions_columns.getActionsColumns)({
    onCreateRule,
    onCreateRuleFromEql,
    actionTimelineToShow,
    deleteTimelines,
    enableExportTimelineDownloader,
    onOpenDeleteTimelineModal,
    onOpenTimeline,
    hasCrudAccess
  }) : [])];
};
exports.getTimelinesTableColumns = getTimelinesTableColumns;
/**
 * Renders a table that displays metadata about timelines, (i.e. name,
 * description, etc.)
 */
const TimelinesTable = /*#__PURE__*/_react.default.memo(({
  actionTimelineToShow,
  deleteTimelines,
  defaultPageSize,
  loading: isLoading,
  itemIdToExpandedNotesRowMap,
  enableExportTimelineDownloader,
  onCreateRule,
  onCreateRuleFromEql,
  onOpenDeleteTimelineModal,
  onOpenTimeline,
  onSelectionChange,
  onTableChange,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  searchResults,
  showExtendedColumns,
  sortField,
  sortDirection,
  tableRef,
  timelineType,
  totalSearchResultsCount
}) => {
  const pagination = {
    showPerPageOptions: showExtendedColumns,
    pageIndex,
    pageSize,
    pageSizeOptions: [Math.floor(Math.max(defaultPageSize, 1) / 2), defaultPageSize, defaultPageSize * 2],
    totalItemCount: totalSearchResultsCount
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const selection = {
    selectable: timelineResult => timelineResult.savedObjectId != null && timelineResult.status !== _timeline.TimelineStatus.immutable,
    selectableMessage: selectable => !selectable ? i18n.MISSING_SAVED_OBJECT_ID : undefined,
    onSelectionChange
  };
  const basicTableProps = tableRef != null ? {
    ref: tableRef
  } : {};
  const {
    kibanaSecuritySolutionsPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const columns = (0, _react.useMemo)(() => getTimelinesTableColumns({
    actionTimelineToShow,
    deleteTimelines,
    itemIdToExpandedNotesRowMap,
    enableExportTimelineDownloader,
    onCreateRule,
    onCreateRuleFromEql,
    onOpenDeleteTimelineModal,
    onOpenTimeline,
    onSelectionChange,
    onToggleShowNotes,
    showExtendedColumns,
    timelineType,
    hasCrudAccess: kibanaSecuritySolutionsPrivileges.crud
  }), [actionTimelineToShow, deleteTimelines, itemIdToExpandedNotesRowMap, enableExportTimelineDownloader, onCreateRule, onCreateRuleFromEql, onOpenDeleteTimelineModal, onOpenTimeline, onSelectionChange, onToggleShowNotes, showExtendedColumns, timelineType, kibanaSecuritySolutionsPrivileges]);
  const noItemsMessage = isLoading || searchResults == null ? i18n.LOADING : timelineType === _timeline.TimelineType.template ? i18n.ZERO_TIMELINE_TEMPLATES_MATCH : i18n.ZERO_TIMELINES_MATCH;
  return /*#__PURE__*/_react.default.createElement(BasicTable, (0, _extends2.default)({
    columns: columns,
    "data-test-subj": "timelines-table",
    isExpandable: true,
    isSelectable: actionTimelineToShow.includes('selectable'),
    itemId: "savedObjectId",
    itemIdToExpandedRowMap: itemIdToExpandedNotesRowMap,
    items: searchResults !== null && searchResults !== void 0 ? searchResults : [],
    loading: isLoading,
    noItemsMessage: noItemsMessage,
    onChange: onTableChange,
    pagination: pagination,
    selection: actionTimelineToShow.includes('selectable') ? selection : undefined,
    sorting: sorting
  }, basicTableProps));
});
exports.TimelinesTable = TimelinesTable;
TimelinesTable.displayName = 'TimelinesTable';