"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SEARCH_RESULTS_PER_PAGE = 10;
const OPEN_TIMELINE_MODAL_WIDTH = 1100; // px

const OpenTimelineModal = /*#__PURE__*/_react.default.memo(({
  hideActions = [],
  modalTitle,
  onClose,
  onOpen
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
  "data-test-subj": "open-timeline-modal",
  maxWidth: OPEN_TIMELINE_MODAL_WIDTH,
  onClose: onClose
}, /*#__PURE__*/_react.default.createElement(_.StatefulOpenTimeline, {
  closeModalTimeline: onClose,
  hideActions: hideActions,
  isModal: true,
  defaultPageSize: DEFAULT_SEARCH_RESULTS_PER_PAGE,
  onOpenTimeline: onOpen,
  title: modalTitle !== null && modalTitle !== void 0 ? modalTitle : i18n.OPEN_TIMELINE_TITLE
})));
exports.OpenTimelineModal = OpenTimelineModal;
OpenTimelineModal.displayName = 'OpenTimelineModal';