"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotePreviewsContainer = exports.NotePreviews = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _reactQuery = require("@tanstack/react-query");
var _empty_value = require("../../../../common/components/empty_value");
var _markdown_editor = require("../../../../common/components/markdown_editor");
var _timeline = require("../../../store/timeline");
var _app = require("../../../../common/store/app");
var _helpers = require("../../timeline/body/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline2 = require("../../../../../common/types/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _save_timeline_button = require("../../timeline/header/save_timeline_button");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _kibana = require("../../../../common/lib/kibana");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotePreviewsContainer = _styledComponents.default.section`
  padding-top: ${({
  theme
}) => `${theme.eui.euiSizeS}`};
`;
exports.NotePreviewsContainer = NotePreviewsContainer;
NotePreviewsContainer.displayName = 'NotePreviewsContainer';
const ToggleEventDetailsButtonComponent = ({
  eventId,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const handleClick = (0, _react.useCallback)(() => {
    dispatch(_timeline.timelineActions.toggleDetailPanel({
      panelView: 'eventDetail',
      tabType: _timeline2.TimelineTabs.notes,
      id: timelineId,
      params: {
        eventId,
        indexName: selectedPatterns.join(',')
      }
    }));
  }, [dispatch, eventId, selectedPatterns, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    "aria-label": i18n.TOGGLE_EXPAND_EVENT_DETAILS,
    color: "text",
    iconType: "arrowRight",
    onClick: handleClick
  });
};
const ToggleEventDetailsButton = /*#__PURE__*/_react.default.memo(ToggleEventDetailsButtonComponent);
const DeleteNoteConfirm = /*#__PURE__*/_react.default.memo(({
  closeModal,
  confirmModal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.DELETE_NOTE_CONFIRM,
    onCancel: closeModal,
    onConfirm: confirmModal,
    cancelButtonText: i18n.CANCEL_DELETE_NOTE,
    confirmButtonText: i18n.DELETE_NOTE,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  });
});
DeleteNoteConfirm.displayName = 'DeleteNoteConfirm';
function useDeleteNote(noteId) {
  const {
    services: {
      http
    }
  } = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useMutation)({
    mutationFn: id => {
      return http.fetch('/api/note', {
        method: 'DELETE',
        body: JSON.stringify({
          noteId: id
        })
      });
    },
    onSuccess: () => {
      if (noteId) {
        dispatch(_app.appActions.deleteNote({
          id: noteId
        }));
      }
    },
    onError: err => {
      addError(err, {
        title: i18n.DELETE_NOTE_ERROR(err)
      });
    }
  });
}
const DeleteNoteButton = /*#__PURE__*/_react.default.memo(({
  noteId
}) => {
  const [confirmingNoteId, setConfirmingNoteId] = (0, _react.useState)(null);
  const {
    mutate,
    isLoading
  } = useDeleteNote(noteId);
  const handleOpenDeleteModal = (0, _react.useCallback)(async () => {
    setConfirmingNoteId(noteId);
  }, [noteId]);
  const handleCancelDelete = (0, _react.useCallback)(() => {
    setConfirmingNoteId(null);
  }, []);
  const handleConfirmDelete = (0, _react.useCallback)(() => {
    mutate(noteId);
    setConfirmingNoteId(null);
  }, [mutate, noteId]);
  const disableDelete = (0, _react.useMemo)(() => {
    return isLoading || noteId == null;
  }, [isLoading, noteId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: i18n.DELETE_NOTE,
    "aria-label": i18n.DELETE_NOTE,
    "data-test-subj": 'delete-note',
    color: "text",
    iconType: "trash",
    onClick: handleOpenDeleteModal,
    disabled: disableDelete
  }), confirmingNoteId != null && /*#__PURE__*/_react.default.createElement(DeleteNoteConfirm, {
    closeModal: handleCancelDelete,
    confirmModal: handleConfirmDelete
  }));
});
DeleteNoteButton.displayName = 'DeleteNoteButton';
const NoteActions = /*#__PURE__*/_react.default.memo(({
  eventId,
  timelineId,
  noteId
}) => {
  return eventId && timelineId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ToggleEventDetailsButton, {
    eventId: eventId,
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(DeleteNoteButton, {
    noteId: noteId
  })) : /*#__PURE__*/_react.default.createElement(DeleteNoteButton, {
    noteId: noteId
  });
});
NoteActions.displayName = 'NoteActions';
/**
 * Renders a preview of a note in the All / Open Timelines table
 */

const NotePreviews = /*#__PURE__*/_react.default.memo(({
  eventIdToNoteIds,
  notes,
  timelineId,
  showTimelineDescription
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const timeline = (0, _use_selector.useDeepEqualSelector)(state => timelineId ? getTimeline(state, timelineId) : null);
  const descriptionList = (0, _react.useMemo)(() => showTimelineDescription && timelineId && timeline !== null && timeline !== void 0 && timeline.description ? [{
    username: (0, _empty_value.defaultToEmptyTag)(timeline.updatedBy),
    event: i18n.ADDED_A_DESCRIPTION,
    'data-test-subj': 'note-preview-description',
    id: 'note-preview-description',
    timestamp: timeline.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      "data-test-subj": "updated",
      value: new Date(timeline.updated)
    }) : (0, _empty_value.getEmptyValue)(),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, timeline.description),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      "data-test-subj": "avatar",
      name: timeline.updatedBy != null ? timeline.updatedBy : '?',
      size: "l"
    }),
    actions: /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
      timelineId: timelineId,
      initialFocus: "description"
    })
  }] : [], [timeline, timelineId, showTimelineDescription]);
  const notesList = (0, _react.useMemo)(() => (0, _fp.uniqBy)('savedObjectId', notes).map(note => {
    var _note$eventId, _note$updatedBy, _note$note;
    const eventId = eventIdToNoteIds != null ? Object.entries(eventIdToNoteIds).reduce((acc, [id, noteIds]) => {
      var _note$noteId;
      return noteIds.includes((_note$noteId = note.noteId) !== null && _note$noteId !== void 0 ? _note$noteId : '') ? id : acc;
    }, null) : (_note$eventId = note.eventId) !== null && _note$eventId !== void 0 ? _note$eventId : null;
    return {
      'data-test-subj': `note-preview-${note.savedObjectId}`,
      username: (0, _empty_value.defaultToEmptyTag)(note.updatedBy),
      event: i18n.ADDED_A_NOTE,
      timestamp: note.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        "data-test-subj": "updated",
        value: new Date(note.updated)
      }) : (0, _empty_value.getEmptyValue)(),
      children: /*#__PURE__*/_react.default.createElement("div", {
        className: _helpers.NOTE_CONTENT_CLASS_NAME,
        tabIndex: 0
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        "data-test-subj": "screenReaderOnlyUserAddedANote"
      }, /*#__PURE__*/_react.default.createElement("p", null, `${(_note$updatedBy = note.updatedBy) !== null && _note$updatedBy !== void 0 ? _note$updatedBy : i18n.AN_UNKNOWN_USER} ${i18n.ADDED_A_NOTE}`)), /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, (_note$note = note.note) !== null && _note$note !== void 0 ? _note$note : '')),
      actions: /*#__PURE__*/_react.default.createElement(NoteActions, {
        eventId: eventId,
        timelineId: timelineId,
        noteId: note.savedObjectId
      }),
      timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        "data-test-subj": "avatar",
        name: note.updatedBy != null ? note.updatedBy : '?',
        size: "l"
      })
    };
  }), [eventIdToNoteIds, notes, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    "data-test-subj": "note-comment-list",
    comments: [...descriptionList, ...notesList]
  });
});
exports.NotePreviews = NotePreviews;
NotePreviews.displayName = 'NotePreviews';