"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineDownloader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/types/timeline");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("../../../containers/api");
var _download_blob = require("../../../../common/utils/download_blob");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExportTimeline = ({
  onComplete,
  isEnableDownloader,
  exportedIds
}) => {
  const {
    tabName: timelineType
  } = (0, _reactRouterDom.useParams)();
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const onExportSuccess = (0, _react.useCallback)(exportCount => {
    if (onComplete != null) {
      onComplete();
    }
    addSuccess({
      title: timelineType === _timeline.TimelineType.template ? i18n.SUCCESSFULLY_EXPORTED_TIMELINE_TEMPLATES(exportCount) : i18n.SUCCESSFULLY_EXPORTED_TIMELINES(exportCount),
      'data-test-subj': 'addObjectToContainerSuccess'
    });
  }, [addSuccess, onComplete, timelineType]);
  const onExportFailure = (0, _react.useCallback)(() => {
    if (onComplete != null) {
      onComplete();
    }
  }, [onComplete]);
  (0, _react.useEffect)(() => {
    const downloadTimeline = async () => {
      if (exportedIds !== null && exportedIds !== void 0 && exportedIds.length && isEnableDownloader) {
        const result = await (0, _api.exportSelectedTimeline)({
          ids: exportedIds
        });
        if (result instanceof Blob) {
          (0, _download_blob.downloadBlob)(result, `${i18n.EXPORT_FILENAME}.ndjson`);
          onExportSuccess(exportedIds.length);
        } else {
          onExportFailure();
        }
      }
    };
    downloadTimeline();
    // We probably don't need to have ExportTimeline in the form of a React component.
    // See https://github.com/elastic/kibana/issues/101571 for more detail.
    // But for now, it uses isEnableDownloader as a signal to start downloading.
    // Other variables are excluded from the deps array to avoid false positives
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [exportedIds, isEnableDownloader]);
  return null;
};
ExportTimeline.displayName = 'ExportTimeline';
const TimelineDownloader = /*#__PURE__*/_react.default.memo(ExportTimeline);
exports.TimelineDownloader = TimelineDownloader;