"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteTimelineModal = exports.DELETE_TIMELINE_MODAL_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRouterDom = require("react-router-dom");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/types/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_TIMELINE_MODAL_WIDTH = 600; // px

/**
 * Renders a modal that confirms deletion of a timeline
 */
exports.DELETE_TIMELINE_MODAL_WIDTH = DELETE_TIMELINE_MODAL_WIDTH;
const DeleteTimelineModal = /*#__PURE__*/_react.default.memo(({
  title,
  closeModal,
  onDelete
}) => {
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const warning = tabName === _timeline.TimelineType.template ? i18n.DELETE_TIMELINE_TEMPLATE_WARNING : i18n.DELETE_TIMELINE_WARNING;
  const getTitle = (0, _react.useCallback)(() => {
    const trimmedTitle = title != null ? title.trim() : '';
    const titleResult = !(0, _fp.isEmpty)(trimmedTitle) ? trimmedTitle : i18n.UNTITLED_TIMELINE;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.open.timeline.deleteTimelineModalTitle",
      defaultMessage: "Delete \"{title}\"?",
      "data-test-subj": "title",
      values: {
        title: titleResult
      }
    });
  }, [title]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: i18n.CANCEL,
    confirmButtonText: i18n.DELETE,
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    onCancel: closeModal,
    onConfirm: onDelete,
    title: getTitle()
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "warning"
  }, warning));
});
exports.DeleteTimelineModal = DeleteTimelineModal;
DeleteTimelineModal.displayName = 'DeleteTimelineModal';