"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewNote = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _markdown_editor = require("../../../../common/components/markdown_editor");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewNoteTabs = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
NewNoteTabs.displayName = 'NewNoteTabs';

/** An input for entering a new note  */
const NewNote = /*#__PURE__*/_react.default.memo(({
  note,
  noteInputHeight,
  updateNewNote,
  autoFocusDisabled = false
}) => {
  return /*#__PURE__*/_react.default.createElement(NewNoteTabs, {
    "data-test-subj": "new-note-tabs"
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownEditor, {
    ariaLabel: i18n.NOTE,
    onChange: updateNewNote,
    value: note,
    dataTestSubj: "add-a-note",
    height: noteInputHeight,
    autoFocusDisabled: autoFocusDisabled
  }));
});
exports.NewNote = NewNote;
NewNote.displayName = 'NewNote';