"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphOverlay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("../../../helpers");
var _use_selector = require("../../../common/hooks/use_selector");
var _constants = require("../../../common/store/inputs/constants");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _column_headers = require("../timeline/body/column_headers");
var _actions = require("../../../common/store/actions");
var _view = require("../../../resolver/view");
var _use_timeline_data_filters = require("../../containers/use_timeline_data_filters");
var _timeline = require("../../store/timeline");
var _defaults = require("../../store/timeline/defaults");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SESSION_VIEW_FULL_SCREEN = 'sessionViewFullScreen';
const OverlayStyle = (0, _styledComponents.css)`
  display: flex;
  flex-direction: column;
  flex: 1;
  width: 100%;
`;
const OverlayContainer = _styledComponents.default.div`
  ${OverlayStyle}
`;
const FullScreenOverlayStyles = (0, _styledComponents.css)`
  position: fixed;
  top: 0;
  bottom: 2em;
  left: 0;
  right: 0;
  z-index: ${_uiTheme.euiThemeVars.euiZLevel3};
`;
const FullScreenOverlayContainer = _styledComponents.default.div`
  ${FullScreenOverlayStyles}
`;
const StyledResolver = (0, _styledComponents.default)(_view.Resolver)`
  height: 100%;
`;
const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `background-color: ${theme.eui.euiColorEmptyShade};`}
  overflow: hidden;
  width: 100%;
  &.${SESSION_VIEW_FULL_SCREEN} {
    ${({
  theme
}) => `padding: 0 ${theme.eui.euiSizeM}`}
  }
`;
const GraphOverlayComponent = ({
  SessionView,
  Navigation,
  scopeId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    } else if ((0, _helpers.isTimelineScope)(scopeId)) {
      return _timeline.timelineSelectors.getTimelineByIdSelector();
    }
  }, [scopeId]);
  const defaults = (0, _helpers.isInTableScope)(scopeId) ? _securitysolutionDataTable.tableDefaults : _defaults.timelineDefaults;
  const {
    graphEventId,
    sessionViewConfig
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref;
    return (_ref = getScope && getScope(state, scopeId)) !== null && _ref !== void 0 ? _ref : defaults;
  });
  const fullScreen = (0, _react.useMemo)(() => (0, _column_headers.isFullScreen)({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId),
    timelineFullScreen
  }), [globalFullScreen, scopeId, timelineFullScreen]);
  (0, _react.useEffect)(() => {
    return () => {
      const scopedActions = (0, _helpers.getScopedActions)(scopeId);
      if (scopedActions) {
        dispatch(scopedActions.updateGraphEventId({
          id: scopeId,
          graphEventId: ''
        }));
      }
      if ((0, _helpers.isActiveTimeline)(scopeId)) {
        dispatch(_actions.inputsActions.setFullScreen({
          id: _constants.InputsModelId.timeline,
          fullScreen: false
        }));
      } else {
        dispatch(_actions.inputsActions.setFullScreen({
          id: _constants.InputsModelId.global,
          fullScreen: false
        }));
      }
    };
  }, [dispatch, scopeId]);
  const {
    from,
    to,
    shouldUpdate,
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  const sessionContainerRef = (0, _react.useRef)(null);
  (0, _react.useLayoutEffect)(() => {
    if (fullScreen && sessionContainerRef.current) {
      sessionContainerRef.current.setAttribute('style', FullScreenOverlayStyles.join(''));
    } else if (sessionContainerRef.current) {
      sessionContainerRef.current.setAttribute('style', OverlayStyle.join(''));
    }
  }, [fullScreen]);
  if (!(0, _helpers.isActiveTimeline)(scopeId) && sessionViewConfig !== null) {
    return /*#__PURE__*/_react.default.createElement(OverlayContainer, {
      "data-test-subj": "overlayContainer",
      ref: sessionContainerRef
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "none",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, Navigation), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(ScrollableFlexItem, {
      grow: 2,
      className: fullScreen ? SESSION_VIEW_FULL_SCREEN : ''
    }, SessionView)));
  } else if (fullScreen && !(0, _helpers.isActiveTimeline)(scopeId)) {
    return /*#__PURE__*/_react.default.createElement(FullScreenOverlayContainer, {
      "data-test-subj": "overlayContainer"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, Navigation)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), graphEventId !== undefined ? /*#__PURE__*/_react.default.createElement(StyledResolver, {
      databaseDocumentID: graphEventId,
      resolverComponentInstanceID: scopeId,
      indices: selectedPatterns,
      shouldUpdate: shouldUpdate,
      filters: {
        from,
        to
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(OverlayContainer, {
      "data-test-subj": "overlayContainer"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, Navigation)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), graphEventId !== undefined ? /*#__PURE__*/_react.default.createElement(StyledResolver, {
      databaseDocumentID: graphEventId,
      resolverComponentInstanceID: scopeId,
      indices: selectedPatterns,
      shouldUpdate: shouldUpdate,
      filters: {
        from,
        to
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  }
};
const GraphOverlay = /*#__PURE__*/_react.default.memo(GraphOverlayComponent);
exports.GraphOverlay = GraphOverlay;