"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_KPI_TITLE = exports.UNSAVED = exports.TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = exports.SOURCE_IP_KPI_TITLE = exports.READ_MORE = exports.PROCESS_KPI_TITLE = exports.INSPECT_TIMELINE_TITLE = exports.HOST_KPI_TITLE = exports.DESTINATION_IP_KPI_TITLE = exports.CLOSE_TIMELINE_OR_TEMPLATE = exports.AUTOSAVED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSE_TIMELINE_OR_TEMPLATE = isTimeline => _i18n.i18n.translate('xpack.securitySolution.timeline.flyout.header.closeTimelineButtonLabel', {
  defaultMessage: 'Close {isTimeline, select, true {timeline} false {template}}',
  values: {
    isTimeline
  }
});
exports.CLOSE_TIMELINE_OR_TEMPLATE = CLOSE_TIMELINE_OR_TEMPLATE;
const UNSAVED = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.unsavedLabel', {
  defaultMessage: 'Unsaved'
});
exports.UNSAVED = UNSAVED;
const AUTOSAVED = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.autosavedLabel', {
  defaultMessage: 'Autosaved'
});
exports.AUTOSAVED = AUTOSAVED;
const INSPECT_TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.inspectTimelineTitle', {
  defaultMessage: 'Timeline'
});
exports.INSPECT_TIMELINE_TITLE = INSPECT_TIMELINE_TITLE;
const PROCESS_KPI_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.kpis.processKpiTitle', {
  defaultMessage: 'Processes'
});
exports.PROCESS_KPI_TITLE = PROCESS_KPI_TITLE;
const HOST_KPI_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.kpis.hostKpiTitle', {
  defaultMessage: 'Hosts'
});
exports.HOST_KPI_TITLE = HOST_KPI_TITLE;
const SOURCE_IP_KPI_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.kpis.sourceIpKpiTitle', {
  defaultMessage: 'Source IPs'
});
exports.SOURCE_IP_KPI_TITLE = SOURCE_IP_KPI_TITLE;
const DESTINATION_IP_KPI_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.kpis.destinationKpiTitle', {
  defaultMessage: 'Destination IPs'
});
exports.DESTINATION_IP_KPI_TITLE = DESTINATION_IP_KPI_TITLE;
const USER_KPI_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.kpis.userKpiTitle', {
  defaultMessage: 'Users'
});
exports.USER_KPI_TITLE = USER_KPI_TITLE;
const READ_MORE = _i18n.i18n.translate('xpack.securitySolution.timeline.properties.readMore', {
  defaultMessage: 'Read More'
});
exports.READ_MORE = READ_MORE;
const TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = ({
  isOpen,
  title
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.properties.timelineToggleButtonAriaLabel', {
  values: {
    isOpen,
    title
  },
  defaultMessage: '{isOpen, select, false {Open} true {Close} other {Toggle}} timeline {title}'
});
exports.TIMELINE_TOGGLE_BUTTON_ARIA_LABEL = TIMELINE_TOGGLE_BUTTON_ARIA_LABEL;