"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTimelineButton = exports.ADD_TIMELINE_BUTTON_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _open_timeline_modal_button = require("../../open_timeline/open_timeline_modal/open_timeline_modal_button");
var _open_timeline_modal = require("../../open_timeline/open_timeline_modal");
var i18n = _interopRequireWildcard(require("../../timeline/properties/translations"));
var _helpers = require("../../timeline/properties/helpers");
var _new_template_timeline = require("../../timeline/properties/new_template_timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TIMELINE_BUTTON_CLASS_NAME = 'add-timeline-button';
exports.ADD_TIMELINE_BUTTON_CLASS_NAME = ADD_TIMELINE_BUTTON_CLASS_NAME;
const actionTimelineToHide = ['createFrom'];
const AddTimelineButtonComponent = ({
  timelineId
}) => {
  const [showActions, setShowActions] = (0, _react.useState)(false);
  const [showTimelineModal, setShowTimelineModal] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setShowActions(!showActions), [showActions]);
  const onClosePopover = (0, _react.useCallback)(() => setShowActions(false), []);
  const onCloseTimelineModal = (0, _react.useCallback)(() => setShowTimelineModal(false), []);
  const onOpenTimelineModal = (0, _react.useCallback)(() => {
    onClosePopover();
    setShowTimelineModal(true);
  }, [onClosePopover]);
  const PopoverButtonIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: ADD_TIMELINE_BUTTON_CLASS_NAME,
    "data-test-subj": "settings-plus-in-circle",
    iconType: "plusInCircle",
    color: "primary",
    size: "m",
    onClick: onButtonClick,
    "aria-label": i18n.ADD_TIMELINE
  }), [onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    button: PopoverButtonIcon,
    id: "timelineSettingsPopover",
    panelProps: {
      'data-test-subj': 'timeline-addPopupPanel'
    },
    isOpen: showActions,
    closePopover: onClosePopover,
    ownFocus: true,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_helpers.NewTimeline, {
    timelineId: timelineId,
    title: i18n.NEW_TIMELINE,
    closeGearMenu: onClosePopover
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_new_template_timeline.NewTemplateTimeline, {
    closeGearMenu: onClosePopover,
    timelineId: timelineId,
    title: i18n.NEW_TEMPLATE_TIMELINE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_open_timeline_modal_button.OpenTimelineModalButton, {
    onClick: onOpenTimelineModal
  }))))), showTimelineModal ? /*#__PURE__*/_react.default.createElement(_open_timeline_modal.OpenTimelineModal, {
    onClose: onCloseTimelineModal,
    hideActions: actionTimelineToHide
  }) : null);
};
const AddTimelineButton = /*#__PURE__*/_react.default.memo(AddTimelineButtonComponent);
exports.AddTimelineButton = AddTimelineButton;