"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncSelectedNode = useSyncSelectedNode;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _side_effect_context = require("./side_effect_context");
var _panel_view_and_parameters = require("../store/panel_view_and_parameters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This custom hook, will maintain the state of the active/selected node with the what the selected nodeID is in url state.
 * This means page refreshes, direct links, back and forward buttons, should always pan to the node defined in the url
 * In the scenario where the nodeList is visible in the panel, there is no selectedNode, but this would naturally default to the origin node based on `serverReturnedResolverData` on initial load and refresh
 * This custom hook should only be called once on resolver load, following that the url nodeID should always equal the selectedNode.  This is currently called in `resolver_without_providers.tsx`.
 */
function useSyncSelectedNode() {
  const dispatch = (0, _reactRedux.useDispatch)();
  const resolverComponentInstanceID = (0, _reactRedux.useSelector)(selectors.resolverComponentInstanceID);
  const locationSearch = (0, _reactRouterDom.useLocation)().search;
  const sideEffectors = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const selectedNode = (0, _reactRedux.useSelector)(selectors.selectedNode);
  const idToNodeMap = (0, _reactRedux.useSelector)(selectors.graphNodeForID);
  const currentPanelParameters = (0, _panel_view_and_parameters.panelViewAndParameters)({
    locationSearch,
    resolverComponentInstanceID
  });
  let urlNodeID;
  if (currentPanelParameters.panelView !== 'nodes') {
    urlNodeID = currentPanelParameters.panelParameters.nodeID;
  }
  (0, _react.useEffect)(() => {
    // use this for the entire render in order to keep things in sync
    if (urlNodeID && idToNodeMap(urlNodeID) && urlNodeID !== selectedNode) {
      dispatch({
        type: 'userSelectedResolverNode',
        payload: {
          nodeID: urlNodeID,
          time: sideEffectors.timestamp()
        }
      });
    }
  }, [currentPanelParameters.panelView, urlNodeID, dispatch, idToNodeMap, selectedNode, sideEffectors]);
}