"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSymbolIDs = useSymbolIDs;
var _react = require("react");
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../store/selectors"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Access the HTML IDs for this Resolver's reusable SVG symbols.
 * In the future these IDs may come from an outside provider (and may be shared by multiple Resolver instances.)
 */
function useSymbolIDs() {
  const resolverComponentInstanceID = (0, _reactRedux.useSelector)(selectors.resolverComponentInstanceID);
  return (0, _react.useMemo)(() => {
    const prefix = `${resolverComponentInstanceID}-symbols`;
    return {
      processNodeLabel: `${prefix}-nodeSymbol`,
      runningProcessCube: `${prefix}-runningCube`,
      runningTriggerCube: `${prefix}-runningTriggerCube`,
      terminatedProcessCube: `${prefix}-terminatedCube`,
      terminatedTriggerCube: `${prefix}-terminatedTriggerCube`,
      processCubeActiveBacking: `${prefix}-activeBacking`,
      loadingCube: `${prefix}-loadingCube`,
      errorCube: `${prefix}-errorCube`
    };
  }, [resolverComponentInstanceID]);
}