"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateSyncingActions = useStateSyncingActions;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_resolver_dispatch = require("./use_resolver_dispatch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a hook that is meant to be used once at the top level of Resolver.
 * It dispatches actions that keep the store in sync with external properties.
 */
function useStateSyncingActions({
  databaseDocumentID,
  resolverComponentInstanceID,
  indices,
  filters,
  shouldUpdate
}) {
  const dispatch = (0, _use_resolver_dispatch.useResolverDispatch)();
  const locationSearch = (0, _reactRouterDom.useLocation)().search;
  (0, _react.useLayoutEffect)(() => {
    dispatch({
      type: 'appReceivedNewExternalProperties',
      payload: {
        databaseDocumentID,
        resolverComponentInstanceID,
        locationSearch,
        indices,
        shouldUpdate,
        filters
      }
    });
  }, [dispatch, databaseDocumentID, resolverComponentInstanceID, locationSearch, indices, shouldUpdate, filters]);
}