"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolverQueryParamCleaner = useResolverQueryParamCleaner;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _parameter_name = require("../store/parameter_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Cleanup any query string keys that were added by this Resolver instance.
 * This works by having a React effect that just has behavior in the 'cleanup' function.
 */
function useResolverQueryParamCleaner() {
  /**
   * Keep a reference to the current search value. This is used in the cleanup function.
   * This value of useLocation().search isn't used directly since that would change and
   * we only want the cleanup to run on unmount or when the resolverComponentInstanceID
   * changes.
   */
  const searchRef = (0, _react.useRef)();
  searchRef.current = (0, _reactRouterDom.useLocation)().search;
  const history = (0, _reactRouterDom.useHistory)();
  const resolverComponentInstanceID = (0, _reactRedux.useSelector)(selectors.resolverComponentInstanceID);
  const resolverKey = (0, _parameter_name.parameterName)(resolverComponentInstanceID);
  (0, _react.useEffect)(() => {
    /**
     * Keep track of the old query string keys so we can remove them.
     */
    const oldResolverKey = resolverKey;
    /**
     * When `idKey` or `eventKey` changes (such as when the `resolverComponentInstanceID` has changed) or when the component unmounts, remove any state from the query string.
     */
    return () => {
      /**
       * This effect must not be invalidated when `search` changes.
       */
      const urlSearchParams = new URLSearchParams(searchRef.current);

      /**
       * Remove old keys from the url
       */
      urlSearchParams.delete(oldResolverKey);
      const relativeURL = {
        search: urlSearchParams.toString()
      };
      history.replace(relativeURL);
    };
  }, [resolverKey, history]);
}