"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCubeAssets = useCubeAssets;
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _react = require("react");
var _use_symbol_ids = require("./use_symbol_ids");
var _use_colors = require("./use_colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides colors and HTML IDs used to render the 'cube' graphic that accompanies nodes.
 */
function useCubeAssets(cubeType, isProcessTrigger) {
  const SymbolIds = (0, _use_symbol_ids.useSymbolIDs)();
  const colorMap = (0, _use_colors.useColors)();
  const nodeAssets = (0, _react.useMemo)(() => ({
    runningProcessCube: {
      backingFill: colorMap.processBackingFill,
      cubeSymbol: `#${SymbolIds.runningProcessCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.runningProcess', {
        defaultMessage: 'Running Process'
      }),
      isLabelFilled: true,
      labelButtonFill: 'primary',
      strokeColor: _uiTheme.euiThemeVars.euiColorPrimary
    },
    loadingCube: {
      backingFill: colorMap.processBackingFill,
      cubeSymbol: `#${SymbolIds.loadingCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.loadingProcess', {
        defaultMessage: 'Loading Process'
      }),
      isLabelFilled: false,
      labelButtonFill: 'primary',
      strokeColor: _uiTheme.euiThemeVars.euiColorPrimary
    },
    errorCube: {
      backingFill: colorMap.processBackingFill,
      cubeSymbol: `#${SymbolIds.errorCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.errorProcess', {
        defaultMessage: 'Error Process'
      }),
      isLabelFilled: false,
      labelButtonFill: 'primary',
      strokeColor: _uiTheme.euiThemeVars.euiColorPrimary
    },
    runningTriggerCube: {
      backingFill: colorMap.triggerBackingFill,
      cubeSymbol: `#${SymbolIds.runningTriggerCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.runningTrigger', {
        defaultMessage: 'Running Trigger'
      }),
      isLabelFilled: true,
      labelButtonFill: 'danger',
      strokeColor: _uiTheme.euiThemeVars.euiColorDanger
    },
    terminatedProcessCube: {
      backingFill: colorMap.processBackingFill,
      cubeSymbol: `#${SymbolIds.terminatedProcessCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.terminatedProcess', {
        defaultMessage: 'Terminated Process'
      }),
      isLabelFilled: false,
      labelButtonFill: 'primary',
      strokeColor: _uiTheme.euiThemeVars.euiColorPrimary
    },
    terminatedTriggerCube: {
      backingFill: colorMap.triggerBackingFill,
      cubeSymbol: `#${SymbolIds.terminatedTriggerCube}`,
      descriptionFill: colorMap.descriptionText,
      descriptionText: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.terminatedTrigger', {
        defaultMessage: 'Terminated Trigger'
      }),
      isLabelFilled: false,
      labelButtonFill: 'danger',
      strokeColor: _uiTheme.euiThemeVars.euiColorDanger
    }
  }), [SymbolIds, colorMap]);
  if (cubeType === 'terminated') {
    if (isProcessTrigger) {
      return nodeAssets.terminatedTriggerCube;
    } else {
      return nodeAssets[processTypeToCube.processTerminated];
    }
  } else if (cubeType === 'running') {
    if (isProcessTrigger) {
      return nodeAssets[processTypeToCube.processCausedAlert];
    } else {
      return nodeAssets[processTypeToCube.processRan];
    }
  } else if (cubeType === 'error') {
    return nodeAssets[processTypeToCube.processError];
  } else {
    return nodeAssets[processTypeToCube.processLoading];
  }
}
const processTypeToCube = {
  processCreated: 'runningProcessCube',
  processRan: 'runningProcessCube',
  processTerminated: 'terminatedProcessCube',
  unknownProcessEvent: 'runningProcessCube',
  processCausedAlert: 'runningTriggerCube',
  processLoading: 'loadingCube',
  processError: 'errorCube',
  unknownEvent: 'runningProcessCube'
};