"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeEventsInCategory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("../styles");
var _styles2 = require("./styles");
var _breadcrumbs = require("./breadcrumbs");
var eventModel = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _panel_loading = require("./panel_loading");
var _descriptive_name = require("./descriptive_name");
var _use_link_props = require("../use_link_props");
var _use_resolver_dispatch = require("../use_resolver_dispatch");
var _use_formatted_date = require("./use_formatted_date");
var _expand_dotted = require("../../../../common/utils/expand_dotted");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

/**
 * Render a list of events that are related to `nodeID` and that have a category of `eventType`.
 */
const NodeEventsInCategory = /*#__PURE__*/(0, _react.memo)(function ({
  nodeID,
  eventCategory
}) {
  const node = (0, _reactRedux.useSelector)(state => selectors.graphNodeForID(state)(nodeID));
  const isLoading = (0, _reactRedux.useSelector)(selectors.isLoadingNodeEventsInCategory);
  const hasError = (0, _reactRedux.useSelector)(selectors.hadErrorLoadingNodeEventsInCategory);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, null)) : /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
    hasBorder: true,
    "data-test-subj": "resolver:panel:events-in-category"
  }, hasError || !node ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.errorPrimary', {
      defaultMessage: 'Unable to load events.'
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "resolver:nodeEventsInCategory:error"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.errorSecondary",
    defaultMessage: "An error occurred when fetching the events."
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NodeEventsInCategoryBreadcrumbs, {
    nodeName: node.name,
    eventCategory: eventCategory,
    nodeID: nodeID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(NodeEventList, {
    eventCategory: eventCategory,
    nodeID: nodeID
  }))));
});

/**
 * Rendered for each event in the list.
 */
exports.NodeEventsInCategory = NodeEventsInCategory;
const NodeEventsListItem = /*#__PURE__*/(0, _react.memo)(function ({
  event,
  nodeID,
  eventCategory
}) {
  const expandedEvent = (0, _expand_dotted.expandDottedObject)(event);
  const timestamp = eventModel.eventTimestamp(expandedEvent);
  const eventID = eventModel.eventID(expandedEvent);
  const winlogRecordID = eventModel.winlogRecordID(expandedEvent);
  const date = (0, _use_formatted_date.useFormattedDate)(timestamp) || _i18n.i18n.translate('xpack.securitySolution.enpdoint.resolver.panelutils.noTimestampRetrieved', {
    defaultMessage: 'No timestamp retrieved'
  });
  const linkProps = (0, _use_link_props.useLinkProps)({
    panelView: 'eventDetail',
    panelParameters: {
      nodeID,
      eventCategory,
      eventID,
      eventTimestamp: String(timestamp),
      winlogRecordID: String(winlogRecordID)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_styles2.BoldCode, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.categoryAndType",
    values: {
      category: eventModel.eventCategory(expandedEvent).join(', '),
      eventType: eventModel.eventType(expandedEvent).join(', ')
    },
    defaultMessage: "{category} {eventType}"
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledTime, {
    dateTime: date
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.atTime",
    values: {
      date
    },
    defaultMessage: "@ {date}"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "resolver:panel:node-events-in-category:event-link"
  }, linkProps), /*#__PURE__*/_react.default.createElement(_descriptive_name.DescriptiveName, {
    event: expandedEvent
  })));
});

/**
 * Renders a list of events with a separator in between.
 */
const NodeEventList = /*#__PURE__*/(0, _react.memo)(function NodeEventList({
  eventCategory,
  nodeID
}) {
  const events = (0, _reactRedux.useSelector)(selectors.nodeEventsInCategory);
  const dispatch = (0, _use_resolver_dispatch.useResolverDispatch)();
  const handleLoadMore = (0, _react.useCallback)(() => {
    dispatch({
      type: 'userRequestedAdditionalRelatedEvents'
    });
  }, [dispatch]);
  const isLoading = (0, _reactRedux.useSelector)(selectors.isLoadingMoreNodeEventsInCategory);
  const hasMore = (0, _reactRedux.useSelector)(selectors.lastRelatedEventResponseContainsCursor);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, events.map((event, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(NodeEventsListItem, {
    nodeID: nodeID,
    eventCategory: eventCategory,
    event: event
  }), index === events.length - 1 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }))), hasMore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'primary',
    size: "s",
    fill: true,
    onClick: handleLoadMore,
    isLoading: isLoading,
    "data-test-subj": "resolver:nodeEventsInCategory:loadMore"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.nodeEventsByType.loadMore",
    defaultMessage: "Load More Data"
  }))));
});

/**
 * Renders `Breadcrumbs`.
 */
const NodeEventsInCategoryBreadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  nodeName,
  eventCategory,
  nodeID
}) {
  const eventCount = (0, _reactRedux.useSelector)(state => selectors.totalRelatedEventCountForNode(state)(nodeID));
  const eventsInCategoryCount = (0, _reactRedux.useSelector)(state => selectors.relatedEventCountOfTypeForNode(state)(nodeID, eventCategory));
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)({
    panelView: 'nodes'
  });
  const nodeDetailNavProps = (0, _use_link_props.useLinkProps)({
    panelView: 'nodeDetail',
    panelParameters: {
      nodeID
    }
  });
  const nodeEventsNavProps = (0, _use_link_props.useLinkProps)({
    panelView: 'nodeEvents',
    panelParameters: {
      nodeID
    }
  });
  return /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processEventListByType.events', {
        defaultMessage: 'Events'
      }),
      'data-test-subj': 'resolver:node-events-in-category:breadcrumbs:node-list-link',
      ...nodesLinkNavProps
    }, {
      text: nodeName,
      ...nodeDetailNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventList.numberOfEvents",
        values: {
          totalCount: eventCount
        },
        defaultMessage: "{totalCount} Events"
      }),
      ...nodeEventsNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventList.countByCategory",
        values: {
          count: eventsInCategoryCount,
          category: eventCategory
        },
        defaultMessage: "{count} {category}"
      })
    }]
  });
});