"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeEvents = NodeEvents;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _breadcrumbs = require("./breadcrumbs");
var event = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _styles = require("../styles");
var _panel_loading = require("./panel_loading");
var _use_link_props = require("../use_link_props");
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

function NodeEvents({
  nodeID
}) {
  const processEvent = (0, _reactRedux.useSelector)(state => nodeDataModel.firstEvent(selectors.nodeDataForID(state)(nodeID)));
  const nodeStats = (0, _reactRedux.useSelector)(state => selectors.nodeStats(state)(nodeID));
  if (processEvent === undefined || nodeStats === undefined) {
    return /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, null));
  } else {
    return /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(NodeEventsBreadcrumbs, {
      nodeName: event.processNameSafeVersion(processEvent),
      nodeID: nodeID,
      totalEventCount: nodeStats.total
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(EventCategoryLinks, {
      nodeID: nodeID,
      relatedStats: nodeStats
    }));
  }
}

/**
 * This view gives counts for all the related events of a process grouped by related event type.
 * It should look something like:
 *
 * | Count                  | Event Type                 |
 * | :--------------------- | :------------------------- |
 * | 5                      | DNS                        |
 * | 12                     | Registry                   |
 * | 2                      | Network                    |
 *
 */
const EventCategoryLinks = /*#__PURE__*/(0, _react.memo)(function ({
  nodeID,
  relatedStats
}) {
  const rows = (0, _react.useMemo)(() => {
    return Object.entries(relatedStats.byCategory).map(([eventType, count]) => {
      return {
        eventType,
        count
      };
    });
  }, [relatedStats.byCategory]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'count',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.count', {
      defaultMessage: 'Count'
    }),
    'data-test-subj': 'resolver:panel:node-events:event-type-count',
    width: '20%',
    sortable: true
  }, {
    field: 'eventType',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.eventType', {
      defaultMessage: 'Event Type'
    }),
    width: '80%',
    sortable: true,
    render(eventType) {
      return /*#__PURE__*/_react.default.createElement(NodeEventsLink, {
        nodeID: nodeID,
        eventType: eventType
      }, eventType);
    }
  }], [nodeID]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: rows,
    columns: columns,
    sorting: true
  });
});
const NodeEventsBreadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  nodeID,
  nodeName,
  totalEventCount
}) {
  return /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processEventCounts.events', {
        defaultMessage: 'Events'
      }),
      ...(0, _use_link_props.useLinkProps)({
        panelView: 'nodes'
      })
    }, {
      text: nodeName,
      ...(0, _use_link_props.useLinkProps)({
        panelView: 'nodeDetail',
        panelParameters: {
          nodeID
        }
      })
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedCounts.numberOfEventsInCrumb",
        values: {
          totalCount: totalEventCount
        },
        defaultMessage: "{totalCount} Events"
      }),
      ...(0, _use_link_props.useLinkProps)({
        panelView: 'nodeEvents',
        panelParameters: {
          nodeID
        }
      })
    }]
  });
});
const NodeEventsLink = /*#__PURE__*/(0, _react.memo)(({
  nodeID,
  eventType,
  children
}) => {
  const props = (0, _use_link_props.useLinkProps)({
    panelView: 'nodeEventsInCategory',
    panelParameters: {
      nodeID,
      eventCategory: eventType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "resolver:panel:node-events:event-type-link"
  }, props), children);
});