"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _node_events_of_type = require("./node_events_of_type");
var _node_events = require("./node_events");
var _node_detail = require("./node_detail");
var _node_list = require("./node_list");
var _event_detail = require("./event_detail");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

/**
 * Show the panel that matches the `panelViewAndParameters` (derived from the browser's location.search)
 */

const PanelRouter = /*#__PURE__*/(0, _react.memo)(function () {
  const params = (0, _reactRedux.useSelector)(selectors.panelViewAndParameters);
  if (params.panelView === 'nodeDetail') {
    return /*#__PURE__*/_react.default.createElement(_node_detail.NodeDetail, {
      nodeID: params.panelParameters.nodeID
    });
  } else if (params.panelView === 'nodeEvents') {
    return /*#__PURE__*/_react.default.createElement(_node_events.NodeEvents, {
      nodeID: params.panelParameters.nodeID
    });
  } else if (params.panelView === 'nodeEventsInCategory') {
    return /*#__PURE__*/_react.default.createElement(_node_events_of_type.NodeEventsInCategory, {
      nodeID: params.panelParameters.nodeID,
      eventCategory: params.panelParameters.eventCategory
    });
  } else if (params.panelView === 'eventDetail') {
    return /*#__PURE__*/_react.default.createElement(_event_detail.EventDetail, {
      nodeID: params.panelParameters.nodeID,
      eventCategory: params.panelParameters.eventCategory
    });
  } else {
    /* The default 'Event List' / 'List of all processes' view */
    return /*#__PURE__*/_react.default.createElement(_node_list.NodeList, null);
  }
});
exports.PanelRouter = PanelRouter;