"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CubeForProcess = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_cube_assets = require("../use_cube_assets");
var _use_symbol_ids = require("../use_symbol_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

/**
 * Icon representing a process node.
 */
const CubeForProcess = /*#__PURE__*/(0, _react.memo)(function ({
  className,
  size = '2.15em',
  state,
  isOrigin,
  'data-test-subj': dataTestSubj
}) {
  const {
    cubeSymbol,
    strokeColor
  } = (0, _use_cube_assets.useCubeAssets)(state, false);
  const {
    processCubeActiveBacking
  } = (0, _use_symbol_ids.useSymbolIDs)();
  return /*#__PURE__*/_react.default.createElement(StyledSVG, {
    className: className,
    width: size,
    height: size,
    viewBox: "0 0 34 34",
    "data-test-subj": dataTestSubj,
    isOrigin: isOrigin,
    style: {
      verticalAlign: 'middle'
    }
  }, /*#__PURE__*/_react.default.createElement("desc", null, _i18n.i18n.translate('xpack.securitySolution.resolver.node_icon', {
    defaultMessage: `{state, select, running {Running Process} terminated {Terminated Process} loading {Loading Process} error {Error Process}}`,
    values: {
      state
    }
  })), isOrigin && /*#__PURE__*/_react.default.createElement("use", {
    xlinkHref: `#${processCubeActiveBacking}`,
    fill: "transparent",
    x: 0,
    y: -1,
    stroke: strokeColor,
    strokeDashoffset: 0,
    width: "100%",
    height: "100%"
  }), /*#__PURE__*/_react.default.createElement("use", {
    role: "presentation",
    xlinkHref: cubeSymbol,
    x: 5.25,
    y: 4.25,
    width: "70%",
    height: "70%",
    opacity: "1",
    className: "cube"
  }));
});
exports.CubeForProcess = CubeForProcess;
const StyledSVG = _styledComponents.default.svg`
  margin-right: ${props => props.isOrigin ? '0.15em' : 0};
`;