"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyablePanelField = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_colors = require("../use_colors");
var _styles = require("../styles");
var _side_effect_context = require("../side_effect_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

const StyledCopyableField = _styledComponents.default.div`
  border-radius: 3px;
  padding: 4px;
  transition: background 0.2s ease;

  ${_styles.StyledPanel}:hover & {
    background-color: ${props => props.backgroundColor};

    &:hover {
      background-color: ${props => props.activeBackgroundColor};
      color: #fff;
    }
  }
`;

/**
 * Field that behaves similarly to the current implementation of copyable fields in timeline as of 7.10
 * When the panel is hovered, these fields will show a gray background
 * When you then hover over these fields they will show a blue background and a tooltip with a copy button will appear
 */
const CopyablePanelField = /*#__PURE__*/(0, _react.memo)(({
  textToCopy,
  content
}) => {
  var _useKibana$services$n;
  const {
    linkColor,
    copyableFieldBackground
  } = (0, _use_colors.useColors)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const toasts = (_useKibana$services$n = (0, _public.useKibana)().services.notifications) === null || _useKibana$services$n === void 0 ? void 0 : _useKibana$services$n.toasts;
  const onMouseEnter = () => setIsOpen(true);
  const onMouseLeave = () => setIsOpen(false);
  const hoverArea = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(StyledCopyableField, {
    backgroundColor: copyableFieldBackground,
    "data-test-subj": "resolver:panel:copyable-field-hover-area",
    activeBackgroundColor: linkColor,
    onMouseEnter: onMouseEnter
  }, content), [content, copyableFieldBackground, linkColor]);
  const {
    writeTextToClipboard
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const onClick = (0, _react.useCallback)(async () => {
    try {
      await writeTextToClipboard(textToCopy);
    } catch (error) {
      if (toasts) {
        toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.securitySolution.resolver.panel.copyFailureTitle', {
            defaultMessage: 'Copy Failure'
          })
        });
      }
    }
  }, [textToCopy, toasts, writeTextToClipboard]);
  return /*#__PURE__*/_react.default.createElement("div", {
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: 'downCenter',
    button: hoverArea,
    closePopover: onMouseLeave,
    hasArrow: false,
    isOpen: isOpen,
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.securitySolution.resolver.panel.copyToClipboard', {
      defaultMessage: 'Copy to Clipboard'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.resolver.panel.copyToClipboard', {
      defaultMessage: 'Copy to Clipboard'
    }),
    color: "text",
    "data-test-subj": "resolver:panel:clipboard",
    iconType: "copyClipboard",
    onClick: onClick
  }))));
});
exports.CopyablePanelField = CopyablePanelField;