"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumbs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styles = require("./styles");
var _use_colors = require("../use_colors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */

/**
 * Breadcrumb menu
 */
const Breadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  breadcrumbs
}) {
  // Just tagging the last crumb with `data-test-subj` for testing
  const crumbsWithLastSubject = (0, _react.useMemo)(() => {
    const lastcrumb = breadcrumbs.slice(-1).map(crumb => {
      crumb['data-test-subj'] = 'resolver:breadcrumbs:last';
      // Manually set here as setting truncate={true} on ThemedBreadcrumbs truncates all parts of the full path
      crumb.truncate = true;
      return crumb;
    });
    return [...breadcrumbs.slice(0, -1), ...lastcrumb];
  }, [breadcrumbs]);
  const {
    resolverBreadcrumbBackground,
    resolverEdgeText
  } = (0, _use_colors.useColors)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles.ThemedBreadcrumbs, {
    background: resolverBreadcrumbBackground,
    text: resolverEdgeText,
    breadcrumbs: crumbsWithLastSubject,
    truncate: false
  }));
});
exports.Breadcrumbs = Breadcrumbs;