"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedText = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable react/display-name */
/**
 * A component that renders an element with breaking opportunities (`<wbr>`s)
 * spliced into text children at word boundaries.
 */
const GeneratedText = /*#__PURE__*/_react.default.memo(function ({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, processedValue());
  function processedValue() {
    return _react.default.Children.map(children, child => {
      if (typeof child === 'string') {
        const valueSplitByWordBoundaries = child.split(/\b/);
        if (valueSplitByWordBoundaries.length < 2) {
          return valueSplitByWordBoundaries[0];
        }
        return [valueSplitByWordBoundaries[0], ...valueSplitByWordBoundaries.splice(1).reduce(function (generatedTextMemo, value) {
          return [...generatedTextMemo, value, /*#__PURE__*/_react.default.createElement("wbr", null)];
        }, [])];
      } else {
        return child;
      }
    });
  }
});
exports.GeneratedText = GeneratedText;