"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverReducer = void 0;
var _redux = require("redux");
var _methods = require("./camera/methods");
var _selectors = require("./selectors");
var _reducer = require("./camera/reducer");
var _reducer2 = require("./data/reducer");
var _scaling_constants = require("./camera/scaling_constants");
var _isometric_taxi_layout = require("../models/indexed_process_tree/isometric_taxi_layout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uiReducer = (state = {
  ariaActiveDescendant: null,
  selectedNode: null
}, action) => {
  if (action.type === 'serverReturnedResolverData') {
    const next = {
      ...state,
      ariaActiveDescendant: action.payload.result.originID,
      selectedNode: action.payload.result.originID
    };
    return next;
  } else if (action.type === 'userFocusedOnResolverNode') {
    const next = {
      ...state,
      ariaActiveDescendant: action.payload.nodeID
    };
    return next;
  } else if (action.type === 'userSelectedResolverNode') {
    const next = {
      ...state,
      selectedNode: action.payload.nodeID,
      ariaActiveDescendant: action.payload.nodeID
    };
    return next;
  } else if (action.type === 'appReceivedNewExternalProperties') {
    const next = {
      ...state,
      locationSearch: action.payload.locationSearch,
      resolverComponentInstanceID: action.payload.resolverComponentInstanceID
    };
    return next;
  } else {
    return state;
  }
};
const concernReducers = (0, _redux.combineReducers)({
  camera: _reducer.cameraReducer,
  data: _reducer2.dataReducer,
  ui: uiReducer
});
const resolverReducer = (state, action) => {
  const nextState = concernReducers(state, action);
  if (action.type === 'userSelectedResolverNode' || action.type === 'userFocusedOnResolverNode') {
    const position = (0, _isometric_taxi_layout.nodePosition)((0, _selectors.layout)(nextState), action.payload.nodeID);
    if (position) {
      const withAnimation = {
        ...nextState,
        camera: (0, _methods.animatePanning)(nextState.camera, action.payload.time, position, _scaling_constants.panAnimationDuration)
      };
      return withAnimation;
    } else {
      return nextState;
    }
  } else {
    return nextState;
  }
};
exports.resolverReducer = resolverReducer;