"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverMiddlewareFactory = void 0;
var _resolver_tree_fetcher = require("./resolver_tree_fetcher");
var _related_events_fetcher = require("./related_events_fetcher");
var _current_related_event_fetcher = require("./current_related_event_fetcher");
var _node_data_fetcher = require("./node_data_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The `redux` middleware that the application uses to trigger side effects.
 * All data fetching should be done here.
 * For actions that the application triggers directly, use `app` as a prefix for the type.
 * For actions that are triggered as a result of server interaction, use `server` as a prefix for the type.
 */
const resolverMiddlewareFactory = dataAccessLayer => {
  return api => next => {
    const resolverTreeFetcher = (0, _resolver_tree_fetcher.ResolverTreeFetcher)(dataAccessLayer, api);
    const relatedEventsFetcher = (0, _related_events_fetcher.RelatedEventsFetcher)(dataAccessLayer, api);
    const currentRelatedEventFetcher = (0, _current_related_event_fetcher.CurrentRelatedEventFetcher)(dataAccessLayer, api);
    const nodeDataFetcher = (0, _node_data_fetcher.NodeDataFetcher)(dataAccessLayer, api);
    return async action => {
      next(action);
      resolverTreeFetcher();
      relatedEventsFetcher();
      nodeDataFetcher();
      currentRelatedEventFetcher();
    };
  };
};
exports.resolverMiddlewareFactory = resolverMiddlewareFactory;