"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentRelatedEventFetcher = CurrentRelatedEventFetcher;
var _lodash = require("lodash");
var selectors = _interopRequireWildcard(require("../selectors"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * @description - This api is called after every state change.
 * If the current view is the `eventDetail` view it will request the event details from the server.
 * @export
 * @param {DataAccessLayer} dataAccessLayer
 * @param {MiddlewareAPI<Dispatch<ResolverAction>, ResolverState>} api
 * @returns {() => void}
 */
function CurrentRelatedEventFetcher(dataAccessLayer, api) {
  let last;
  return async () => {
    const state = api.getState();
    const newParams = selectors.panelViewAndParameters(state);
    const indices = selectors.eventIndices(state);
    const oldParams = last;
    last = newParams;

    // If the panel view params have changed and the current panel view is the `eventDetail`, then fetch the event details for that eventID.
    if (!(0, _lodash.isEqual)(newParams, oldParams) && newParams.panelView === 'eventDetail') {
      const currentEventID = newParams.panelParameters.eventID;
      const currentNodeID = newParams.panelParameters.nodeID;
      const currentEventCategory = newParams.panelParameters.eventCategory;
      const currentEventTimestamp = newParams.panelParameters.eventTimestamp;
      const winlogRecordID = newParams.panelParameters.winlogRecordID;
      api.dispatch({
        type: 'appRequestedCurrentRelatedEventData'
      });
      const detectedBounds = selectors.detectedBounds(state);
      const timeRangeFilters = detectedBounds !== undefined ? undefined : selectors.timeRangeFilters(state);
      let result = null;
      try {
        result = await dataAccessLayer.event({
          nodeID: currentNodeID,
          eventCategory: [currentEventCategory],
          eventTimestamp: currentEventTimestamp,
          eventID: currentEventID,
          winlogRecordID,
          indexPatterns: indices,
          timeRange: timeRangeFilters
        });
      } catch (error) {
        api.dispatch({
          type: 'serverFailedToReturnCurrentRelatedEventData'
        });
      }
      if (result) {
        api.dispatch({
          type: 'serverReturnedCurrentRelatedEventData',
          payload: result
        });
      } else {
        api.dispatch({
          type: 'serverFailedToReturnCurrentRelatedEventData'
        });
      }
    }
  };
}