"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../common/constants");
var _landing = require("./pages/landing");
var _overview = require("./pages/overview");
var _data_quality = require("./pages/data_quality");
var _detection_response = require("./pages/detection_response");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _entity_analytics = require("./pages/entity_analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.overview
}, /*#__PURE__*/_react.default.createElement(_overview.StatefulOverview, null)));
const DetectionResponseRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.detectionAndResponse
}, /*#__PURE__*/_react.default.createElement(_detection_response.DetectionResponse, null)));
const LandingRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.landing
}, /*#__PURE__*/_react.default.createElement(_landing.LandingPage, null)));
const EntityAnalyticsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.entityAnalytics
}, /*#__PURE__*/_react.default.createElement(_entity_analytics.EntityAnalyticsPage, null)));
const DataQualityRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.dataQuality
}, /*#__PURE__*/_react.default.createElement(_data_quality.DataQuality, null)));
const routes = [{
  path: _constants.OVERVIEW_PATH,
  component: OverviewRoutes
}, {
  path: _constants.DETECTION_RESPONSE_PATH,
  component: DetectionResponseRoutes
}, {
  path: _constants.LANDING_PATH,
  render: LandingRoutes
}, {
  path: _constants.ENTITY_ANALYTICS_PATH,
  render: EntityAnalyticsRoutes
}, {
  path: _constants.DATA_QUALITY_PATH,
  component: DataQualityRoutes
}];
exports.routes = routes;