"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WARM = exports.VIEW_EVENTS = exports.VIEW_ALERTS = exports.UNMANAGED = exports.TOP = exports.TECHNICAL_PREVIEW = exports.SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = exports.RECENT_TIMELINES = exports.NEWS_FEED_TITLE = exports.HOT = exports.FROZEN = exports.EVENTS = exports.ENTITY_ANALYTICS_LICENSE_DESC = exports.ELASTIC_COMMON_SCHEMA = exports.DETECTION_RESPONSE_TITLE = exports.DATA_QUALITY_TITLE = exports.COLD = exports.BETA = exports.ALERT_TREND = exports.ADD_TO_CASE_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_CASE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.addToCaseSuccessToast', {
  defaultMessage: 'Successfully added data quality results to the case'
});
exports.ADD_TO_CASE_SUCCESS = ADD_TO_CASE_SUCCESS;
const BETA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.betaBadge', {
  defaultMessage: 'Beta'
});
exports.BETA = BETA;
const COLD = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseCold', {
  defaultMessage: 'cold'
});
exports.COLD = COLD;
const DATA_QUALITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.pageTitle', {
  defaultMessage: 'Data Quality'
});
exports.DATA_QUALITY_TITLE = DATA_QUALITY_TITLE;
const ELASTIC_COMMON_SCHEMA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.elasticCommonSchemaReferenceLink', {
  defaultMessage: 'Elastic Common Schema (ECS)'
});
exports.ELASTIC_COMMON_SCHEMA = ELASTIC_COMMON_SCHEMA;
const SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = settingName => _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.securitySolutionDefaultIndexTooltip', {
  values: {
    settingName
  },
  defaultMessage: `Indices and patterns from the {settingName} setting`
});
exports.SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP;
const EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.eventsTitle', {
  defaultMessage: 'Event count'
});
exports.EVENTS = EVENTS;
const FROZEN = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseFrozen', {
  defaultMessage: 'frozen'
});
exports.FROZEN = FROZEN;
const HOT = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseHot', {
  defaultMessage: 'hot'
});
exports.HOT = HOT;
const NEWS_FEED_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.newsFeedSidebarTitle', {
  defaultMessage: 'Security news'
});
exports.NEWS_FEED_TITLE = NEWS_FEED_TITLE;
const RECENT_TIMELINES = _i18n.i18n.translate('xpack.securitySolution.overview.recentTimelinesSidebarTitle', {
  defaultMessage: 'Recent timelines'
});
exports.RECENT_TIMELINES = RECENT_TIMELINES;
const ALERT_TREND = _i18n.i18n.translate('xpack.securitySolution.overview.signalCountTitle', {
  defaultMessage: 'Alert trend'
});
exports.ALERT_TREND = ALERT_TREND;
const TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.overview.topNLabel', {
  values: {
    fieldName
  },
  defaultMessage: `Top {fieldName}`
});
exports.TOP = TOP;
const UNMANAGED = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseUnmanaged', {
  defaultMessage: 'unmanaged'
});
exports.UNMANAGED = UNMANAGED;
const VIEW_ALERTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewAlertsButtonLabel', {
  defaultMessage: 'View alerts'
});
exports.VIEW_ALERTS = VIEW_ALERTS;
const VIEW_EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewEventsButtonLabel', {
  defaultMessage: 'View events'
});
exports.VIEW_EVENTS = VIEW_EVENTS;
const WARM = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseWarm', {
  defaultMessage: 'warm'
});
exports.WARM = WARM;
const DETECTION_RESPONSE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.pageTitle', {
  defaultMessage: 'Detection & Response'
});
exports.DETECTION_RESPONSE_TITLE = DETECTION_RESPONSE_TITLE;
const ENTITY_ANALYTICS_LICENSE_DESC = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.pageDesc', {
  defaultMessage: 'Detect threats from users and hosts within your network with Entity Analytics'
});
exports.ENTITY_ANALYTICS_LICENSE_DESC = ENTITY_ANALYTICS_LICENSE_DESC;
const TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.technicalPreviewLabel', {
  defaultMessage: 'Technical Preview'
});
exports.TECHNICAL_PREVIEW = TECHNICAL_PREVIEW;