"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _risk_score = require("../components/entity_analytics/risk_score");
var _search_strategy = require("../../../common/search_strategy");
var _translations = require("../../app/translations");
var _paywall = require("../../common/components/paywall");
var _use_ml_capabilities = require("../../common/components/ml/hooks/use_ml_capabilities");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _sourcerer = require("../../common/containers/sourcerer");
var _page_wrapper = require("../../common/components/page_wrapper");
var _header_page = require("../../common/components/header_page");
var _landing_page = require("../../common/components/landing_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _header = require("../components/entity_analytics/header");
var _anomalies = require("../components/entity_analytics/anomalies");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsComponent = () => {
  const {
    indicesExist,
    loading: isSourcererLoading,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)();
  const {
    isPlatinumOrTrialLicense,
    capabilitiesFetched
  } = (0, _use_ml_capabilities.useMlCapabilities)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPlatinumOrTrialLicense && capabilitiesFetched && /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    indexPattern: indexPattern
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "entityAnalyticsPage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.ENTITY_ANALYTICS
  }), !isPlatinumOrTrialLicense && capabilitiesFetched ? /*#__PURE__*/_react.default.createElement(_paywall.Paywall, {
    heading: i18n.ENTITY_ANALYTICS_LICENSE_DESC
  }) : isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "entityAnalyticsLoader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "entityAnalyticsSections"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_header.EntityAnalyticsHeader, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: _search_strategy.RiskScoreEntity.host
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: _search_strategy.RiskScoreEntity.user
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_anomalies.EntityAnalyticsAnomalies, null))))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalytics
  }));
};
const EntityAnalyticsPage = /*#__PURE__*/_react.default.memo(EntityAnalyticsComponent);
exports.EntityAnalyticsPage = EntityAnalyticsPage;