"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCtiDashboardLinks = exports.TAG_REQUEST_BODY = void 0;
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAG_REQUEST_BODY_SEARCH = 'threat intel';
const TAG_REQUEST_BODY = {
  type: 'tag',
  search: TAG_REQUEST_BODY_SEARCH,
  searchFields: ['name']
};
exports.TAG_REQUEST_BODY = TAG_REQUEST_BODY;
const useCtiDashboardLinks = ({
  to,
  from,
  tiDataSources = []
}) => {
  var _useKibana$services$d;
  const [installedDashboardIds, setInstalledDashboardIds] = (0, _react.useState)([]);
  const dashboardLocator = (_useKibana$services$d = (0, _kibana.useKibana)().services.dashboard) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.locator;
  const savedObjectsClient = (0, _kibana.useKibana)().services.savedObjects.client;
  const handleTagsReceived = (0, _react.useCallback)(TagsSO => {
    var _TagsSO$savedObjects;
    if (TagsSO !== null && TagsSO !== void 0 && (_TagsSO$savedObjects = TagsSO.savedObjects) !== null && _TagsSO$savedObjects !== void 0 && _TagsSO$savedObjects.length) {
      return savedObjectsClient.find({
        type: 'dashboard',
        hasReference: {
          id: TagsSO.savedObjects[0].id,
          type: 'tag'
        }
      });
    }
    return undefined;
  }, [savedObjectsClient]);
  (0, _react.useEffect)(() => {
    if (savedObjectsClient) {
      savedObjectsClient.find(TAG_REQUEST_BODY).then(handleTagsReceived).then(async DashboardsSO => {
        var _DashboardsSO$savedOb;
        if (DashboardsSO !== null && DashboardsSO !== void 0 && (_DashboardsSO$savedOb = DashboardsSO.savedObjects) !== null && _DashboardsSO$savedOb !== void 0 && _DashboardsSO$savedOb.length) {
          setInstalledDashboardIds(DashboardsSO.savedObjects.map(SO => {
            var _SO$id;
            return (_SO$id = SO.id) !== null && _SO$id !== void 0 ? _SO$id : '';
          }).filter(Boolean));
        }
      });
    }
  }, [handleTagsReceived, savedObjectsClient]);
  const listItems = tiDataSources.map(tiDataSource => {
    const listItem = {
      title: tiDataSource.name,
      count: tiDataSource.count,
      path: ''
    };
    if (tiDataSource.dashboardId && installedDashboardIds.includes(tiDataSource.dashboardId) && dashboardLocator) {
      listItem.path = dashboardLocator.getRedirectUrl({
        dashboardId: tiDataSource.dashboardId,
        timeRange: {
          to,
          from
        }
      });
    }
    return listItem;
  });
  return {
    listItems
  };
};
exports.useCtiDashboardLinks = useCtiDashboardLinks;