"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignalsByCategory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _alerts_histogram_panel = require("../../../detections/components/alerts_kpis/alerts_histogram_panel");
var _use_signal_index = require("../../../detections/containers/detection_engine/alerts/use_signal_index");
var _actions = require("../../../common/store/inputs/actions");
var _constants = require("../../../common/store/inputs/constants");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _use_filters_for_signals_by_category = require("./use_filters_for_signals_by_category");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SignalsByCategoryComponent = ({
  combinedQueries,
  filters,
  headerChildren,
  onlyField,
  paddingSize,
  query,
  showLegend,
  setAbsoluteRangeDatePickerTarget = _constants.InputsModelId.global,
  runtimeMappings,
  hideQueryToggle = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const filtersForSignalsByCategory = (0, _use_filters_for_signals_by_category.useFiltersForSignalsByCategory)(filters);
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: setAbsoluteRangeDatePickerTarget,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch, setAbsoluteRangeDatePickerTarget]);
  return /*#__PURE__*/_react.default.createElement(_alerts_histogram_panel.AlertsHistogramPanel, {
    combinedQueries: combinedQueries,
    filters: filtersForSignalsByCategory,
    headerChildren: headerChildren,
    legendPosition: 'right',
    onlyField: onlyField,
    paddingSize: paddingSize,
    query: query,
    showLegend: showLegend,
    showLinkToAlerts: onlyField == null ? true : false,
    showStackBy: onlyField == null,
    showTotalAlertsCount: true,
    signalIndexName: signalIndexName,
    runtimeMappings: runtimeMappings,
    title: i18n.ALERT_TREND,
    titleSize: onlyField == null ? 'm' : 's',
    updateDateRange: updateDateRangeCallback,
    hideQueryToggle: hideQueryToggle
  });
};
SignalsByCategoryComponent.displayName = 'SignalsByCategoryComponent';
const SignalsByCategory = /*#__PURE__*/_react.default.memo(SignalsByCategoryComponent);
exports.SignalsByCategory = SignalsByCategory;