"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _filters = require("../recent_timelines/filters");
var _recent_timelines = require("../recent_timelines");
var _news_feed = require("../../../common/components/news_feed");
var _sidebar_header = require("../../../common/components/sidebar_header");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _recent_cases = require("../recent_cases");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SidebarSpacerComponent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}));
SidebarSpacerComponent.displayName = 'SidebarSpacerComponent';
const Sidebar = /*#__PURE__*/_react.default.memo(({
  recentTimelinesFilterBy,
  setRecentTimelinesFilterBy
}) => {
  const recentTimelinesFilters = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_filters.Filters, {
    filterBy: recentTimelinesFilterBy,
    setFilterBy: setRecentTimelinesFilterBy
  }), [recentTimelinesFilterBy, setRecentTimelinesFilterBy]);

  // only render the recently created cases view if the user has at least read permissions
  const hasCasesReadPermissions = (0, _kibana.useGetUserCasesPermissions)().read;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "l"
  }, hasCasesReadPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_recent_cases.RecentCases, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
    title: i18n.RECENT_TIMELINES
  }, recentTimelinesFilters), /*#__PURE__*/_react.default.createElement(_recent_timelines.StatefulRecentTimelines, {
    filterBy: recentTimelinesFilterBy
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_news_feed.StatefulNewsFeed, {
    enableNewsFeedSetting: _constants.ENABLE_NEWS_FEED_SETTING,
    newsFeedSetting: _constants.NEWS_FEED_URL_SETTING
  })));
});
exports.Sidebar = Sidebar;
Sidebar.displayName = 'Sidebar';